/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class DebugServerException
extends IOException {
    public final String description;
    public final String fileName;
    public final int lineNumber;
    public final int column;

    private DebugServerException(String description, String fileName, int lineNumber, int column) {
        this.description = description;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.column = column;
    }

    public String toReadableMessage() {
        return this.description + "\n  at " + this.fileName + ":" + this.lineNumber + ":" + this.column;
    }

    @Nullable
    public static DebugServerException parse(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(str);
            String fullFileName = jsonObject.getString("filename");
            return new DebugServerException(jsonObject.getString("description"), DebugServerException.shortenFileName(fullFileName), jsonObject.getInt("lineNumber"), jsonObject.getInt("column"));
        }
        catch (JSONException e) {
            FLog.w((String)"React", (String)("Could not parse DebugServerException from: " + str), (Throwable)e);
            return null;
        }
    }

    private static String shortenFileName(String fullFileName) {
        String[] parts = fullFileName.split("/");
        return parts[parts.length - 1];
    }
}

