/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.WritableNativeMap;
import javax.annotation.Nullable;

public class PromiseImpl
implements Promise {
    private static final String DEFAULT_ERROR = "EUNSPECIFIED";
    @Nullable
    private Callback mResolve;
    @Nullable
    private Callback mReject;

    public PromiseImpl(@Nullable Callback resolve, @Nullable Callback reject) {
        this.mResolve = resolve;
        this.mReject = reject;
    }

    @Override
    public void resolve(Object value) {
        if (this.mResolve != null) {
            this.mResolve.invoke(value);
        }
    }

    @Override
    public void reject(Throwable reason) {
        this.reject(DEFAULT_ERROR, reason.getMessage(), reason);
    }

    @Override
    @Deprecated
    public void reject(String reason) {
        this.reject(DEFAULT_ERROR, reason, null);
    }

    @Override
    public void reject(String code, Throwable extra) {
        this.reject(code, extra.getMessage(), extra);
    }

    @Override
    public void reject(String code, String reason, Throwable extra) {
        if (this.mReject != null) {
            if (code == null) {
                code = DEFAULT_ERROR;
            }
            WritableNativeMap errorInfo = new WritableNativeMap();
            errorInfo.putString("code", code);
            errorInfo.putString("message", reason);
            this.mReject.invoke(errorInfo);
        }
    }
}

