/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.Bundle;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import javax.annotation.Nullable;

public class Arguments {
    public static WritableArray createArray() {
        return new WritableNativeArray();
    }

    public static WritableMap createMap() {
        return new WritableNativeMap();
    }

    public static WritableNativeArray fromJavaArgs(Object[] args) {
        WritableNativeArray arguments = new WritableNativeArray();
        for (int i = 0; i < args.length; ++i) {
            Object argument = args[i];
            if (argument == null) {
                arguments.pushNull();
                continue;
            }
            Class<?> argumentClass = argument.getClass();
            if (argumentClass == Boolean.class) {
                arguments.pushBoolean((Boolean)argument);
                continue;
            }
            if (argumentClass == Integer.class) {
                arguments.pushDouble(((Integer)argument).doubleValue());
                continue;
            }
            if (argumentClass == Double.class) {
                arguments.pushDouble((Double)argument);
                continue;
            }
            if (argumentClass == Float.class) {
                arguments.pushDouble(((Float)argument).doubleValue());
                continue;
            }
            if (argumentClass == String.class) {
                arguments.pushString(argument.toString());
                continue;
            }
            if (argumentClass == WritableNativeMap.class) {
                arguments.pushMap((WritableNativeMap)argument);
                continue;
            }
            if (argumentClass == WritableNativeArray.class) {
                arguments.pushArray((WritableNativeArray)argument);
                continue;
            }
            throw new RuntimeException("Cannot convert argument of type " + argumentClass);
        }
        return arguments;
    }

    public static WritableArray fromArray(Object array) {
        WritableArray catalystArray = Arguments.createArray();
        if (array instanceof String[]) {
            for (String v : (String[])array) {
                catalystArray.pushString(v);
            }
        } else if (array instanceof Bundle[]) {
            for (Bundle v : (Bundle[])array) {
                catalystArray.pushMap(Arguments.fromBundle(v));
            }
        } else if (array instanceof int[]) {
            for (int v : (int[])array) {
                catalystArray.pushInt(v);
            }
        } else if (array instanceof float[]) {
            for (float v : (float[])array) {
                catalystArray.pushDouble(v);
            }
        } else if (array instanceof double[]) {
            for (double v : (double[])array) {
                catalystArray.pushDouble(v);
            }
        } else if (array instanceof boolean[]) {
            for (boolean v : (boolean[])array) {
                catalystArray.pushBoolean(v);
            }
        } else {
            throw new IllegalArgumentException("Unknown array type " + array.getClass());
        }
        return catalystArray;
    }

    public static WritableMap fromBundle(Bundle bundle) {
        WritableMap map = Arguments.createMap();
        for (String key : bundle.keySet()) {
            Object value = bundle.get(key);
            if (value == null) {
                map.putNull(key);
                continue;
            }
            if (value.getClass().isArray()) {
                map.putArray(key, Arguments.fromArray(value));
                continue;
            }
            if (value instanceof String) {
                map.putString(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    map.putInt(key, (Integer)value);
                    continue;
                }
                map.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                map.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof Bundle) {
                map.putMap(key, Arguments.fromBundle((Bundle)value));
                continue;
            }
            throw new IllegalArgumentException("Could not convert " + value.getClass());
        }
        return map;
    }

    @Nullable
    public static Bundle toBundle(@Nullable ReadableMap readableMap) {
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        if (!iterator.hasNextKey()) {
            return null;
        }
        Bundle bundle = new Bundle();
        block8: while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType readableType = readableMap.getType(key);
            switch (readableType) {
                case Null: {
                    bundle.putString(key, null);
                    continue block8;
                }
                case Boolean: {
                    bundle.putBoolean(key, readableMap.getBoolean(key));
                    continue block8;
                }
                case Number: {
                    bundle.putDouble(key, readableMap.getDouble(key));
                    continue block8;
                }
                case String: {
                    bundle.putString(key, readableMap.getString(key));
                    continue block8;
                }
                case Map: {
                    bundle.putBundle(key, Arguments.toBundle(readableMap.getMap(key)));
                    continue block8;
                }
                case Array: {
                    throw new UnsupportedOperationException("Arrays aren't supported yet.");
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return bundle;
    }
}

