/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.MemoryPressure;
import com.facebook.react.bridge.ReactContext;
import javax.annotation.Nullable;

public class MemoryPressureRouter {
    private static final String ACTION_TRIM_MEMORY = "com.facebook.catalyst.ACTION_TRIM_MEMORY";
    @Nullable
    private CatalystInstance mCatalystInstance;
    private final ComponentCallbacks2 mCallbacks = new ComponentCallbacks2(){

        public void onTrimMemory(int level) {
            MemoryPressureRouter.this.trimMemory(level);
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }
    };

    @TargetApi(value=16)
    public static boolean handleDebugIntent(Activity activity, String action) {
        switch (action) {
            case "com.facebook.catalyst.ACTION_TRIM_MEMORY": {
                MemoryPressureRouter.simulateTrimMemory(activity, 60);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    MemoryPressureRouter(Context context) {
        context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.mCallbacks);
    }

    public void onNewReactContextCreated(ReactContext reactContext) {
        this.mCatalystInstance = reactContext.getCatalystInstance();
    }

    public void onReactInstanceDestroyed() {
        this.mCatalystInstance = null;
    }

    public void destroy(Context context) {
        context.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this.mCallbacks);
    }

    private void trimMemory(int level) {
        if (level >= 80) {
            this.dispatchMemoryPressure(MemoryPressure.CRITICAL);
        } else if (level >= 40 || level == 15) {
            this.dispatchMemoryPressure(MemoryPressure.MODERATE);
        }
    }

    private void dispatchMemoryPressure(MemoryPressure level) {
        if (this.mCatalystInstance != null) {
            this.mCatalystInstance.handleMemoryPressure(level);
        }
    }

    private static void simulateTrimMemory(Activity activity, int level) {
        activity.getApplication().onTrimMemory(level);
        activity.onTrimMemory(level);
    }
}

