/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import android.text.TextUtils;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleIdentifier;
import com.facebook.hermes.intl.ParsedLocaleIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class LocaleObjectAndroid
implements ILocaleObject<Locale> {
    private Locale mLocale = null;
    private ParsedLocaleIdentifier mParsedLocaleIdentifier = null;
    private boolean mIsDirty = false;

    private LocaleObjectAndroid(Locale locale) {
        assert (Build.VERSION.SDK_INT < 24);
        this.mLocale = locale;
    }

    private LocaleObjectAndroid(String localeId) throws JSRangeErrorException {
        assert (Build.VERSION.SDK_INT < 24);
        this.mParsedLocaleIdentifier = LocaleIdentifier.parseLocaleId(localeId);
        this.reInitFromParsedLocaleIdentifier();
    }

    private LocaleObjectAndroid(ParsedLocaleIdentifier parsedLocaleIdentifier) throws JSRangeErrorException {
        assert (Build.VERSION.SDK_INT < 24);
        this.mParsedLocaleIdentifier = parsedLocaleIdentifier;
        this.reInitFromParsedLocaleIdentifier();
    }

    private void ensureParsedLocaleIdentifier() throws JSRangeErrorException {
        if (this.mParsedLocaleIdentifier == null) {
            this.mParsedLocaleIdentifier = Build.VERSION.SDK_INT < 21 ? LocaleIdentifier.parseLocaleId("en") : LocaleIdentifier.parseLocaleId(this.mLocale.toLanguageTag());
        }
    }

    private void reInitFromParsedLocaleIdentifier() throws JSRangeErrorException {
        ArrayList<String> values;
        String key;
        if (Build.VERSION.SDK_INT < 21) {
            this.mLocale = Locale.ENGLISH;
            return;
        }
        StringBuffer localeIdBuffer = new StringBuffer();
        StringBuffer languageSubtagBuffer = new StringBuffer();
        StringBuffer scriptSubtagBuffer = new StringBuffer();
        StringBuffer regionSubtagBuffer = new StringBuffer();
        if (this.mParsedLocaleIdentifier.languageIdentifier.languageSubtag != null && !this.mParsedLocaleIdentifier.languageIdentifier.languageSubtag.isEmpty()) {
            languageSubtagBuffer.append(this.mParsedLocaleIdentifier.languageIdentifier.languageSubtag);
        }
        if (this.mParsedLocaleIdentifier.languageIdentifier.scriptSubtag != null && !this.mParsedLocaleIdentifier.languageIdentifier.scriptSubtag.isEmpty()) {
            scriptSubtagBuffer.append(this.mParsedLocaleIdentifier.languageIdentifier.scriptSubtag);
        }
        if (this.mParsedLocaleIdentifier.languageIdentifier.regionSubtag != null && !this.mParsedLocaleIdentifier.languageIdentifier.regionSubtag.isEmpty()) {
            regionSubtagBuffer.append(this.mParsedLocaleIdentifier.languageIdentifier.regionSubtag);
        }
        LocaleIdentifier.replaceLanguageSubtagIfNeeded(languageSubtagBuffer, scriptSubtagBuffer, regionSubtagBuffer);
        if (languageSubtagBuffer.length() > 0) {
            localeIdBuffer.append(languageSubtagBuffer.toString());
        }
        if (scriptSubtagBuffer.length() > 0) {
            localeIdBuffer.append("-");
            localeIdBuffer.append(scriptSubtagBuffer.toString());
        }
        if (regionSubtagBuffer.length() > 0) {
            localeIdBuffer.append("-");
            localeIdBuffer.append(LocaleIdentifier.replaceRegionSubtagIfNeeded(regionSubtagBuffer));
        }
        if (this.mParsedLocaleIdentifier.languageIdentifier.variantSubtagList != null && !this.mParsedLocaleIdentifier.languageIdentifier.variantSubtagList.isEmpty()) {
            localeIdBuffer.append("-");
            localeIdBuffer.append(TextUtils.join((CharSequence)"-", this.mParsedLocaleIdentifier.languageIdentifier.variantSubtagList));
        }
        if (this.mParsedLocaleIdentifier.otherExtensionsMap != null) {
            for (Map.Entry<Character, ArrayList<String>> entry : this.mParsedLocaleIdentifier.otherExtensionsMap.entrySet()) {
                localeIdBuffer.append("-");
                localeIdBuffer.append(entry.getKey());
                localeIdBuffer.append("-");
                localeIdBuffer.append(TextUtils.join((CharSequence)"-", (Iterable)entry.getValue()));
            }
        }
        if (this.mParsedLocaleIdentifier.transformedLanguageIdentifier != null || this.mParsedLocaleIdentifier.transformedExtensionFields != null) {
            localeIdBuffer.append("-");
            localeIdBuffer.append('t');
            localeIdBuffer.append("-");
            StringBuffer transformedExtension = new StringBuffer();
            if (this.mParsedLocaleIdentifier.transformedLanguageIdentifier != null) {
                transformedExtension.append(this.mParsedLocaleIdentifier.transformedLanguageIdentifier.languageSubtag);
                if (this.mParsedLocaleIdentifier.transformedLanguageIdentifier.scriptSubtag != null) {
                    transformedExtension.append("-");
                    transformedExtension.append(this.mParsedLocaleIdentifier.transformedLanguageIdentifier.scriptSubtag);
                }
                if (this.mParsedLocaleIdentifier.transformedLanguageIdentifier.regionSubtag != null) {
                    transformedExtension.append("-");
                    transformedExtension.append(this.mParsedLocaleIdentifier.transformedLanguageIdentifier.regionSubtag);
                }
                if (this.mParsedLocaleIdentifier.transformedLanguageIdentifier.variantSubtagList != null && !this.mParsedLocaleIdentifier.transformedLanguageIdentifier.variantSubtagList.isEmpty()) {
                    transformedExtension.append("-");
                    transformedExtension.append(TextUtils.join((CharSequence)"-", this.mParsedLocaleIdentifier.transformedLanguageIdentifier.variantSubtagList));
                }
            }
            if (this.mParsedLocaleIdentifier.transformedExtensionFields != null) {
                for (Map.Entry<String, ArrayList<String>> entry : this.mParsedLocaleIdentifier.transformedExtensionFields.entrySet()) {
                    key = entry.getKey();
                    values = entry.getValue();
                    transformedExtension.append("-" + key);
                    for (String value : values) {
                        transformedExtension.append("-" + value);
                    }
                }
                if (transformedExtension.length() > 0 && transformedExtension.charAt(0) == '-') {
                    transformedExtension.deleteCharAt(0);
                }
            }
            localeIdBuffer.append(transformedExtension.toString());
        }
        if (this.mParsedLocaleIdentifier.unicodeExtensionAttributes != null || this.mParsedLocaleIdentifier.unicodeExtensionKeywords != null) {
            localeIdBuffer.append("-");
            localeIdBuffer.append('u');
            localeIdBuffer.append("-");
            StringBuffer extension = new StringBuffer();
            if (this.mParsedLocaleIdentifier.unicodeExtensionAttributes != null) {
                extension.append(TextUtils.join((CharSequence)"-", this.mParsedLocaleIdentifier.unicodeExtensionAttributes));
            }
            if (this.mParsedLocaleIdentifier.unicodeExtensionKeywords != null) {
                for (Map.Entry<String, ArrayList<String>> entry : this.mParsedLocaleIdentifier.unicodeExtensionKeywords.entrySet()) {
                    key = entry.getKey();
                    values = entry.getValue();
                    extension.append("-" + key);
                    for (String value : values) {
                        extension.append("-" + value);
                    }
                }
            }
            if (extension.length() > 0 && extension.charAt(0) == '-') {
                extension.deleteCharAt(0);
            }
            localeIdBuffer.append(extension.toString());
        }
        if (this.mParsedLocaleIdentifier.puExtensions != null) {
            localeIdBuffer.append("-");
            localeIdBuffer.append('x');
            localeIdBuffer.append("-");
            localeIdBuffer.append(TextUtils.join((CharSequence)"-", this.mParsedLocaleIdentifier.puExtensions));
        }
        try {
            this.mLocale = Locale.forLanguageTag(localeIdBuffer.toString());
        }
        catch (RuntimeException ex) {
            throw new JSRangeErrorException(ex.getMessage());
        }
        this.mIsDirty = false;
    }

    private void ensureNotDirty() throws JSRangeErrorException {
        if (this.mIsDirty) {
            try {
                this.reInitFromParsedLocaleIdentifier();
            }
            catch (RuntimeException ex) {
                throw new JSRangeErrorException(ex.getMessage());
            }
            this.mIsDirty = false;
        }
    }

    @Override
    public ArrayList<String> getUnicodeExtensions(String key) throws JSRangeErrorException {
        ArrayList<String> extensions;
        this.ensureNotDirty();
        this.ensureParsedLocaleIdentifier();
        if (this.mParsedLocaleIdentifier.unicodeExtensionKeywords != null && (extensions = this.mParsedLocaleIdentifier.unicodeExtensionKeywords.get(key)) != null) {
            return extensions;
        }
        return new ArrayList<String>();
    }

    @Override
    public HashMap<String, String> getUnicodeExtensions() throws JSRangeErrorException {
        HashMap<String, String> extensions = new HashMap<String, String>();
        if (this.mParsedLocaleIdentifier.unicodeExtensionKeywords != null) {
            for (String key : this.mParsedLocaleIdentifier.unicodeExtensionKeywords.keySet()) {
                ArrayList<String> values = this.mParsedLocaleIdentifier.unicodeExtensionKeywords.get(key);
                extensions.put(key, TextUtils.join((CharSequence)"-", values));
            }
        }
        return extensions;
    }

    @Override
    public void setUnicodeExtensions(String key, ArrayList<String> value) throws JSRangeErrorException {
        this.ensureNotDirty();
        this.ensureParsedLocaleIdentifier();
        if (this.mParsedLocaleIdentifier.unicodeExtensionKeywords == null) {
            this.mParsedLocaleIdentifier.unicodeExtensionKeywords = new TreeMap();
        }
        if (!this.mParsedLocaleIdentifier.unicodeExtensionKeywords.containsKey(key)) {
            this.mParsedLocaleIdentifier.unicodeExtensionKeywords.put(key, new ArrayList());
        }
        this.mParsedLocaleIdentifier.unicodeExtensionKeywords.get(key).clear();
        this.mParsedLocaleIdentifier.unicodeExtensionKeywords.get(key).addAll(value);
        this.mIsDirty = true;
    }

    @Override
    public Locale getLocale() throws JSRangeErrorException {
        this.ensureNotDirty();
        return this.mLocale;
    }

    @Override
    public Locale getLocaleWithoutExtensions() throws JSRangeErrorException {
        this.ensureNotDirty();
        this.ensureParsedLocaleIdentifier();
        ParsedLocaleIdentifier modified = new ParsedLocaleIdentifier();
        modified.languageIdentifier = this.mParsedLocaleIdentifier.languageIdentifier;
        return new LocaleObjectAndroid(modified).getLocale();
    }

    @Override
    public String toCanonicalTag() throws JSRangeErrorException {
        if (Build.VERSION.SDK_INT < 21) {
            return "en";
        }
        return this.getLocale().toLanguageTag();
    }

    @Override
    public String toCanonicalTagWithoutExtensions() throws JSRangeErrorException {
        if (Build.VERSION.SDK_INT < 21) {
            return "en";
        }
        return this.getLocaleWithoutExtensions().toLanguageTag();
    }

    public static ILocaleObject<Locale> createFromLocaleId(String localeId) throws JSRangeErrorException {
        return new LocaleObjectAndroid(localeId);
    }

    public static ILocaleObject<Locale> createFromLocale(Locale locale) {
        return new LocaleObjectAndroid(locale);
    }

    public static ILocaleObject<Locale> createDefault() {
        return new LocaleObjectAndroid(Locale.getDefault());
    }

    @Override
    public ILocaleObject<Locale> cloneObject() throws JSRangeErrorException {
        this.ensureNotDirty();
        return new LocaleObjectAndroid(this.mLocale);
    }
}

