/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.LongDecimalType;
import com.facebook.presto.spi.type.ShortDecimalType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DecimalType
extends AbstractType
implements FixedWidthType {
    public static final int DEFAULT_SCALE = 0;
    public static final int DEFAULT_PRECISION = 38;
    private final int precision;
    private final int scale;

    public static DecimalType createDecimalType(int precision, int scale) {
        if (precision <= 18) {
            return new ShortDecimalType(precision, scale);
        }
        return new LongDecimalType(precision, scale);
    }

    public static DecimalType createDecimalType(int precision) {
        return DecimalType.createDecimalType(precision, 0);
    }

    public static DecimalType createDecimalType() {
        return DecimalType.createDecimalType(38, 0);
    }

    DecimalType(int precision, int scale, Class<?> javaType) {
        super(new TypeSignature("decimal", DecimalType.buildTypeParameters(precision, scale)), javaType);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isShort() {
        return this.precision <= 18;
    }

    void validatePrecisionScale(int precision, int scale, int maxPrecision) {
        if (precision <= 0 || precision > maxPrecision) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "DECIMAL precision must be in range [1, 38]");
        }
        if (scale < 0 || scale > precision) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "DECIMAL scale must be in range [0, precision]");
        }
    }

    private static List<TypeSignatureParameter> buildTypeParameters(int precision, int scale) {
        ArrayList<TypeSignatureParameter> typeParameters = new ArrayList<TypeSignatureParameter>();
        typeParameters.add(TypeSignatureParameter.of(precision));
        typeParameters.add(TypeSignatureParameter.of(scale));
        return Collections.unmodifiableList(typeParameters);
    }
}

