/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractSingleMapBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import java.util.function.BiConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SingleMapBlockWriter
extends AbstractSingleMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMapBlockWriter.class).instanceSize();
    private final int offset;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private final long initialBlockBuilderSize;
    private int positionsWritten;
    private boolean writeToValueNext;

    SingleMapBlockWriter(int start, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder) {
        this.offset = start;
        this.keyBlockBuilder = keyBlockBuilder;
        this.valueBlockBuilder = valueBlockBuilder;
        this.initialBlockBuilderSize = keyBlockBuilder.getSizeInBytes() + valueBlockBuilder.getSizeInBytes();
    }

    @Override
    int getOffset() {
        return this.offset;
    }

    @Override
    Block getRawKeyBlock() {
        return this.keyBlockBuilder;
    }

    @Override
    Block getRawValueBlock() {
        return this.valueBlockBuilder;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() - this.initialBlockBuilderSize;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlockBuilder, this.keyBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.valueBlockBuilder, this.valueBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockBuilder writeByte(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeByte(value);
        } else {
            this.keyBlockBuilder.writeByte(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeShort(value);
        } else {
            this.keyBlockBuilder.writeShort(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeInt(value);
        } else {
            this.keyBlockBuilder.writeInt(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeLong(value);
        } else {
            this.keyBlockBuilder.writeLong(value);
        }
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.writeBytes(source, sourceIndex, length);
        } else {
            this.keyBlockBuilder.writeBytes(source, sourceIndex, length);
        }
        return this;
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.appendStructure(block);
        } else {
            this.keyBlockBuilder.appendStructure(block);
        }
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.appendStructureInternal(block, position);
        } else {
            this.keyBlockBuilder.appendStructureInternal(block, position);
        }
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        BlockBuilder result = this.writeToValueNext ? this.valueBlockBuilder.beginBlockEntry() : this.keyBlockBuilder.beginBlockEntry();
        return result;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.appendNull();
        } else {
            this.keyBlockBuilder.appendNull();
        }
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.readPositionFrom(input);
        } else {
            this.keyBlockBuilder.readPositionFrom(input);
        }
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.writeToValueNext) {
            this.valueBlockBuilder.closeEntry();
        } else {
            this.keyBlockBuilder.closeEntry();
        }
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        this.writeToValueNext = !this.writeToValueNext;
        ++this.positionsWritten;
    }

    @Override
    public int getPositionCount() {
        return this.positionsWritten;
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("SingleMapBlockWriter{positionCount=%d}", this.getPositionCount());
    }
}

