/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class Constraint<T> {
    private final TupleDomain<T> summary;
    private final Optional<Predicate<Map<T, NullableValue>>> predicate;

    public static <V> Constraint<V> alwaysTrue() {
        return new Constraint(TupleDomain.all(), Optional.empty());
    }

    public static <V> Constraint<V> alwaysFalse() {
        return new Constraint(TupleDomain.none(), Optional.of(bindings -> false));
    }

    public Constraint(TupleDomain<T> summary) {
        this(summary, Optional.empty());
    }

    public Constraint(TupleDomain<T> summary, Predicate<Map<T, NullableValue>> predicate) {
        this(summary, Optional.of(predicate));
    }

    public Constraint(TupleDomain<T> summary, Optional<Predicate<Map<T, NullableValue>>> predicate) {
        Objects.requireNonNull(summary, "summary is null");
        Objects.requireNonNull(predicate, "predicate is null");
        this.summary = summary;
        this.predicate = predicate;
    }

    public TupleDomain<T> getSummary() {
        return this.summary;
    }

    public Optional<Predicate<Map<T, NullableValue>>> predicate() {
        return this.predicate;
    }
}

