/*
 * Decompiled with CFR 0.152.
 */
package com.expediagroup.graphql.generator.internal.state;

import com.expediagroup.graphql.generator.annotations.GraphQLType;
import com.expediagroup.graphql.generator.annotations.GraphQLUnion;
import com.expediagroup.graphql.generator.exceptions.ConflictingTypesException;
import com.expediagroup.graphql.generator.exceptions.InvalidCustomUnionException;
import com.expediagroup.graphql.generator.exceptions.TypeNotSupportedException;
import com.expediagroup.graphql.generator.internal.extensions.AnnotationExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KClassExtensionsKt;
import com.expediagroup.graphql.generator.internal.extensions.KTypeExtensionsKt;
import com.expediagroup.graphql.generator.internal.state.KGraphQLType;
import com.expediagroup.graphql.generator.internal.state.TypesCache;
import com.expediagroup.graphql.generator.internal.state.TypesCacheKey;
import com.expediagroup.graphql.generator.internal.types.GraphQLKTypeMetadata;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLTypeReference;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J9\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\r0\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b!J\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b!J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001f\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b*R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/expediagroup/graphql/generator/internal/state/TypesCache;", "Ljava/io/Closeable;", "supportedPackages", "", "", "(Ljava/util/List;)V", "cache", "", "Lcom/expediagroup/graphql/generator/internal/state/KGraphQLType;", "typesUnderConstruction", "", "Lcom/expediagroup/graphql/generator/internal/state/TypesCacheKey;", "buildIfNotUnderConstruction", "Lgraphql/schema/GraphQLType;", "kClass", "Lkotlin/reflect/KClass;", "typeInfo", "Lcom/expediagroup/graphql/generator/internal/types/GraphQLKTypeMetadata;", "build", "Lkotlin/Function1;", "buildIfNotUnderConstruction$graphql_kotlin_schema_generator", "close", "", "doesNotContainGraphQLType", "", "graphQLType", "Lgraphql/schema/GraphQLNamedType;", "doesNotContainGraphQLType$graphql_kotlin_schema_generator", "generateCacheKey", "type", "Lkotlin/reflect/KType;", "get", "cacheKey", "get$graphql_kotlin_schema_generator", "getCacheKeyString", "getCustomUnionNameKey", "union", "Lcom/expediagroup/graphql/generator/annotations/GraphQLUnion;", "isTypeNotSupported", "put", "key", "kGraphQLType", "put$graphql_kotlin_schema_generator", "graphql-kotlin-schema-generator"})
@SourceDebugExtension(value={"SMAP\nTypesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypesCache.kt\ncom/expediagroup/graphql/generator/internal/state/TypesCache\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n553#2,3:161\n2624#3,3:164\n*S KotlinDebug\n*F\n+ 1 TypesCache.kt\ncom/expediagroup/graphql/generator/internal/state/TypesCache\n*L\n113#1:161,3\n135#1:164,3\n*E\n"})
public final class TypesCache
implements Closeable {
    @NotNull
    private final List<String> supportedPackages;
    @NotNull
    private final Map<String, KGraphQLType> cache;
    @NotNull
    private final Set<TypesCacheKey> typesUnderConstruction;

    public TypesCache(@NotNull List<String> supportedPackages) {
        Intrinsics.checkNotNullParameter(supportedPackages, (String)"supportedPackages");
        this.supportedPackages = supportedPackages;
        this.cache = new LinkedHashMap();
        this.typesUnderConstruction = new LinkedHashSet();
    }

    @Nullable
    public final GraphQLNamedType get$graphql_kotlin_schema_generator(@NotNull KType type, @NotNull GraphQLKTypeMetadata typeInfo) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        TypesCacheKey cacheKey = this.generateCacheKey(type, typeInfo);
        return this.get$graphql_kotlin_schema_generator(cacheKey);
    }

    @Nullable
    public final GraphQLNamedType get$graphql_kotlin_schema_generator(@NotNull TypesCacheKey cacheKey) throws ConflictingTypesException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        String string = this.getCacheKeyString(cacheKey);
        if (string == null) {
            return null;
        }
        String cacheKeyString = string;
        KGraphQLType cachedType = this.cache.get(cacheKeyString);
        if (cachedType != null) {
            KClass<?> kClass = KTypeExtensionsKt.getKClass(cacheKey.getType());
            boolean isSameNameButNotSameClass = !Intrinsics.areEqual(cachedType.getKClass(), kClass);
            if (isSameNameButNotSameClass) {
                throw new ConflictingTypesException(cachedType.getKClass(), kClass);
            }
            return cachedType.getGraphQLType();
        }
        return null;
    }

    @Nullable
    public final KGraphQLType put$graphql_kotlin_schema_generator(@NotNull TypesCacheKey key, @NotNull KGraphQLType kGraphQLType) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)kGraphQLType, (String)"kGraphQLType");
        String cacheKey = this.getCacheKeyString(key);
        if (cacheKey != null) {
            this.cache.put(cacheKey, kGraphQLType);
            return kGraphQLType;
        }
        return null;
    }

    private final TypesCacheKey generateCacheKey(KType type, GraphQLKTypeMetadata typeInfo) {
        if (KClassExtensionsKt.isListType(KTypeExtensionsKt.getKClass(type), typeInfo.isDirective())) {
            return new TypesCacheKey(type, typeInfo.getInputType(), null, typeInfo.isDirective(), 4, null);
        }
        GraphQLType customTypeAnnotation = AnnotationExtensionsKt.getCustomTypeAnnotation(typeInfo.getFieldAnnotations());
        if (customTypeAnnotation != null) {
            return new TypesCacheKey(type, typeInfo.getInputType(), customTypeAnnotation.typeName(), false, 8, null);
        }
        GraphQLUnion unionAnnotation = AnnotationExtensionsKt.getUnionAnnotation(typeInfo.getFieldAnnotations());
        if (unionAnnotation != null) {
            if (KClassExtensionsKt.isAnnotationUnion(KTypeExtensionsKt.getKClass(type), typeInfo.getFieldAnnotations())) {
                return new TypesCacheKey(KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Object.class)), null, (boolean)false, null, (int)7, null), typeInfo.getInputType(), this.getCustomUnionNameKey(unionAnnotation), false, 8, null);
            }
            throw new InvalidCustomUnionException(type);
        }
        return new TypesCacheKey(type, typeInfo.getInputType(), null, false, 12, null);
    }

    private final String getCustomUnionNameKey(GraphQLUnion union) {
        return union.name() + ArraysKt.joinToString$default((Object[])Reflection.getOrCreateKotlinClasses((Class[])union.possibleTypes()), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)getCustomUnionNameKey.1.INSTANCE, (int)24, null);
    }

    @Override
    public void close() {
        this.cache.clear();
        this.typesUnderConstruction.clear();
    }

    public final boolean doesNotContainGraphQLType$graphql_kotlin_schema_generator(@NotNull GraphQLNamedType graphQLType) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)graphQLType, (String)"graphQLType");
            Map<String, KGraphQLType> $this$none$iv = this.cache;
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator<Map.Entry<String, KGraphQLType>> iterator = $this$none$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, KGraphQLType> element$iv;
                    Map.Entry<String, KGraphQLType> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    KGraphQLType v = entry.getValue();
                    if (!Intrinsics.areEqual((Object)v.getGraphQLType().getName(), (Object)graphQLType.getName())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final String getCacheKeyString(TypesCacheKey cacheKey) {
        String string;
        if (cacheKey.getName() != null) {
            string = cacheKey.getName();
        } else {
            KType type = cacheKey.getType();
            KClass<?> kClass = KTypeExtensionsKt.getKClass(type);
            if (KClassExtensionsKt.isListType(kClass, cacheKey.isDirective())) {
                string = null;
            } else if (Enum.class.isAssignableFrom(JvmClassMappingKt.getJavaClass(kClass))) {
                string = KClassExtensionsKt.getSimpleName$default(kClass, false, 1, null);
            } else {
                if (this.isTypeNotSupported(type)) {
                    throw new TypeNotSupportedException(type, this.supportedPackages);
                }
                string = KTypeExtensionsKt.getSimpleName(type, cacheKey.getInputType());
            }
        }
        return string;
    }

    private final boolean isTypeNotSupported(KType type) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.supportedPackages;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)KTypeExtensionsKt.getQualifiedName(type), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final graphql.schema.GraphQLType buildIfNotUnderConstruction$graphql_kotlin_schema_generator(@NotNull KClass<?> kClass, @NotNull GraphQLKTypeMetadata typeInfo, @NotNull Function1<? super KClass<?>, ? extends graphql.schema.GraphQLType> build) {
        graphql.schema.GraphQLType graphQLType;
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        Intrinsics.checkNotNullParameter(build, (String)"build");
        if (KClassExtensionsKt.isListType(kClass, typeInfo.isDirective())) {
            return (graphql.schema.GraphQLType)build.invoke(kClass);
        }
        TypesCacheKey cacheKey = this.generateCacheKey(KClassifiers.getStarProjectedType((KClassifier)((KClassifier)kClass)), typeInfo);
        GraphQLNamedType cachedType = this.get$graphql_kotlin_schema_generator(cacheKey);
        GraphQLNamedType graphQLNamedType = cachedType;
        if (graphQLNamedType != null) {
            graphQLType = (graphql.schema.GraphQLType)graphQLNamedType;
        } else if (this.typesUnderConstruction.contains(cacheKey)) {
            GraphQLTypeReference graphQLTypeReference = GraphQLTypeReference.typeRef((String)KClassExtensionsKt.getSimpleName(kClass, typeInfo.getInputType()));
            Intrinsics.checkNotNullExpressionValue((Object)graphQLTypeReference, (String)"typeRef(...)");
            graphQLType = (graphql.schema.GraphQLType)graphQLTypeReference;
        } else {
            this.typesUnderConstruction.add(cacheKey);
            graphql.schema.GraphQLType newType = (graphql.schema.GraphQLType)build.invoke(kClass);
            if (!(newType instanceof GraphQLTypeReference) && newType instanceof GraphQLNamedType) {
                KClass cacheKClass = KClassExtensionsKt.isAnnotationUnion(kClass, typeInfo.getFieldAnnotations()) ? Reflection.getOrCreateKotlinClass(Object.class) : kClass;
                this.put$graphql_kotlin_schema_generator(cacheKey, new KGraphQLType(cacheKClass, (GraphQLNamedType)newType));
            }
            this.typesUnderConstruction.remove(cacheKey);
            graphQLType = newType;
        }
        return graphQLType;
    }
}

