/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.launch;

import com.epam.ta.reportportal.ws.model.OwnedResource;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.statistics.StatisticsResource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LaunchResource
extends OwnedResource {
    @NotNull
    @JsonProperty(value="id", required=true)
    private Long launchId;
    @NotBlank
    @JsonProperty(value="uuid", required=true)
    private String uuid;
    @NotBlank
    @Size(min=3, max=256)
    @JsonProperty(value="name", required=true)
    private @NotBlank @Size(min=3, max=256) String name;
    @NotNull
    @JsonProperty(value="number", required=true)
    private Long number;
    @JsonProperty(value="description")
    @Size(max=1024)
    private @Size(max=1024) String description;
    @NotNull
    @JsonProperty(value="startTime", required=true)
    private Date startTime;
    @JsonProperty(value="endTime")
    private Date endTime;
    @JsonProperty(value="lastModified")
    private Date lastModified;
    @NotNull
    @JsonProperty(value="status", required=true)
    private String status;
    @JsonProperty(value="statistics")
    @Valid
    private StatisticsResource statisticsResource;
    @JsonProperty(value="attributes")
    private Set<ItemAttributeResource> attributes;
    @JsonProperty(value="mode")
    private Mode mode;
    @JsonProperty(value="analysing")
    private Set<String> analyzers = new LinkedHashSet<String>();
    @JsonProperty(value="approximateDuration")
    private double approximateDuration;
    @JsonProperty(value="hasRetries")
    private boolean hasRetries;
    private boolean rerun;

    public double getApproximateDuration() {
        return this.approximateDuration;
    }

    public void setApproximateDuration(double approximateDuration) {
        this.approximateDuration = approximateDuration;
    }

    public Long getLaunchId() {
        return this.launchId;
    }

    public void setLaunchId(Long launchId) {
        this.launchId = launchId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getNumber() {
        return this.number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public StatisticsResource getStatisticsResource() {
        return this.statisticsResource;
    }

    public void setStatisticsResource(StatisticsResource statisticsResource) {
        this.statisticsResource = statisticsResource;
    }

    public Set<ItemAttributeResource> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<ItemAttributeResource> attributes) {
        this.attributes = attributes;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Set<String> getAnalyzers() {
        return this.analyzers;
    }

    public void setAnalyzers(Set<String> analyzers) {
        this.analyzers = analyzers;
    }

    public boolean isHasRetries() {
        return this.hasRetries;
    }

    public boolean getHasRetries() {
        return this.hasRetries;
    }

    public void setHasRetries(boolean hasRetries) {
        this.hasRetries = hasRetries;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LaunchResource{");
        sb.append("launchId=").append(this.launchId);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", number=").append(this.number);
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", startTime=").append(this.startTime);
        sb.append(", endTime=").append(this.endTime);
        sb.append(", lastModified=").append(this.lastModified);
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", statisticsResource=").append(this.statisticsResource);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", mode=").append((Object)this.mode);
        sb.append(", analyzers=").append(this.analyzers);
        sb.append(", approximateDuration=").append(this.approximateDuration);
        sb.append(", hasRetries=").append(this.hasRetries);
        sb.append(", rerun=").append(this.rerun);
        sb.append('}');
        return sb.toString();
    }
}

