/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.launch.AbstractJoinedLaunch;
import com.epam.reportportal.utils.Waiter;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class PrimaryLaunch
extends AbstractJoinedLaunch {
    public PrimaryLaunch(ReportPortalClient rpClient, ListenerParameters parameters, StartLaunchRQ launch, ExecutorService executorService, LaunchIdLock launchIdLock, String instanceUuid) {
        super(rpClient, parameters, launch, executorService, launchIdLock, instanceUuid);
    }

    @Override
    public void finish(FinishExecutionRQ rq) {
        this.stopRunning();
        Callable<Boolean> finishCondition = new Callable<Boolean>(){
            private volatile Collection<String> launches;

            @Override
            public Boolean call() {
                Collection<String> current = PrimaryLaunch.this.lock.getLiveInstanceUuids();
                if (current.isEmpty() || current.size() == 1 && PrimaryLaunch.this.uuid.equals(current.iterator().next())) {
                    return true;
                }
                Boolean changed = Optional.ofNullable(this.launches).map(l -> !l.equals(current)).orElse(Boolean.TRUE);
                this.launches = current;
                if (changed.booleanValue()) {
                    return false;
                }
                return null;
            }
        };
        Boolean finished = Boolean.FALSE;
        while (finished != Boolean.TRUE && finished != null) {
            Waiter waiter = new Waiter("Wait for all launches end").duration(this.getParameters().getClientJoinTimeout(), TimeUnit.MILLISECONDS).pollingEvery(1L, TimeUnit.SECONDS);
            finished = waiter.till(finishCondition);
        }
        this.lock.finishInstanceUuid(this.uuid);
        super.finish(rq);
    }
}

