/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.DummyReportPortalClientHandler;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.step.DefaultStepReporter;
import com.epam.reportportal.service.step.StepReporter;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import io.reactivex.Maybe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launch {
    private static final ThreadLocal<Launch> CURRENT_LAUNCH = new InheritableThreadLocal<Launch>();
    static final Logger LOGGER = LoggerFactory.getLogger(Launch.class);
    private final ListenerParameters parameters;
    private final StepReporter stepReporter;
    protected final ReportPortalClient client;
    public static final Launch NOOP_LAUNCH = new Launch((ReportPortalClient)Proxy.newProxyInstance(Launch.class.getClassLoader(), new Class[]{ReportPortalClient.class}, (InvocationHandler)new DummyReportPortalClientHandler()), new ListenerParameters(), StepReporter.NOOP_STEP_REPORTER){

        @Override
        public Maybe<String> start() {
            return Maybe.empty();
        }

        @Override
        public void finish(FinishExecutionRQ rq) {
        }

        @Override
        public Maybe<String> startTestItem(StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> itemId, FinishTestItemRQ rq) {
            return Maybe.empty();
        }
    };
    public static final Issue NOT_ISSUE = new Issue(){
        public static final String NOT_ISSUE = "NOT_ISSUE";

        public String getIssueType() {
            return NOT_ISSUE;
        }

        public void setComment(String comment) {
            throw new UnsupportedOperationException();
        }

        public void setIssueType(String type) {
            throw new UnsupportedOperationException();
        }

        public void setAutoAnalyzed(boolean autoAnalyzed) {
            throw new UnsupportedOperationException();
        }

        public void setIgnoreAnalyzer(boolean ignoreAnalyzer) {
            throw new UnsupportedOperationException();
        }

        public void setExternalSystemIssues(Set<Issue.ExternalSystemIssue> externalSystemIssues) {
            throw new UnsupportedOperationException();
        }
    };

    Launch(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters listenerParameters, @Nonnull StepReporter reporter) {
        this.parameters = Objects.requireNonNull(listenerParameters, "ListenerParameters shouldn't be NULL");
        this.stepReporter = Objects.requireNonNull(reporter, "StepReporter shouldn't be NULL");
        CURRENT_LAUNCH.set(this);
        this.client = reportPortalClient;
    }

    Launch(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters listenerParameters) {
        this.parameters = Objects.requireNonNull(listenerParameters, "ListenerParameters shouldn't be NULL");
        this.stepReporter = new DefaultStepReporter(this);
        CURRENT_LAUNCH.set(this);
        this.client = Objects.requireNonNull(reportPortalClient, "ReportPortalClient shouldn't be NULL");
    }

    public abstract Maybe<String> start();

    public abstract void finish(FinishExecutionRQ var1);

    public abstract Maybe<String> startTestItem(StartTestItemRQ var1);

    public abstract Maybe<String> startTestItem(Maybe<String> var1, StartTestItemRQ var2);

    public abstract Maybe<String> startTestItem(Maybe<String> var1, Maybe<String> var2, StartTestItemRQ var3);

    public abstract Maybe<OperationCompletionRS> finishTestItem(Maybe<String> var1, FinishTestItemRQ var2);

    public ListenerParameters getParameters() {
        CURRENT_LAUNCH.set(this);
        return this.parameters;
    }

    @Nullable
    public static Launch currentLaunch() {
        return CURRENT_LAUNCH.get();
    }

    @Nonnull
    public StepReporter getStepReporter() {
        return this.stepReporter;
    }

    @Nonnull
    public ReportPortalClient getClient() {
        return this.client;
    }
}

