/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.nio.protocol;

import java.io.IOException;
import rp.org.apache.http.ContentTooLongException;
import rp.org.apache.http.HttpEntity;
import rp.org.apache.http.HttpEntityEnclosingRequest;
import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.entity.ContentType;
import rp.org.apache.http.nio.ContentDecoder;
import rp.org.apache.http.nio.IOControl;
import rp.org.apache.http.nio.entity.ContentBufferEntity;
import rp.org.apache.http.nio.protocol.AbstractAsyncRequestConsumer;
import rp.org.apache.http.nio.util.HeapByteBufferAllocator;
import rp.org.apache.http.nio.util.SimpleInputBuffer;
import rp.org.apache.http.protocol.HttpContext;
import rp.org.apache.http.util.Asserts;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

