/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.nio.codecs;

import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.HttpRequestFactory;
import rp.org.apache.http.annotation.Contract;
import rp.org.apache.http.annotation.ThreadingBehavior;
import rp.org.apache.http.config.MessageConstraints;
import rp.org.apache.http.impl.DefaultHttpRequestFactory;
import rp.org.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import rp.org.apache.http.message.BasicLineParser;
import rp.org.apache.http.message.LineParser;
import rp.org.apache.http.nio.NHttpMessageParser;
import rp.org.apache.http.nio.NHttpMessageParserFactory;
import rp.org.apache.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

