/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.nio.client;

import java.io.IOException;
import rp.org.apache.commons.logging.Log;
import rp.org.apache.commons.logging.LogFactory;
import rp.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import rp.org.apache.http.impl.nio.client.InternalRequestExecutor;
import rp.org.apache.http.impl.nio.reactor.AbstractIODispatch;
import rp.org.apache.http.nio.NHttpClientEventHandler;
import rp.org.apache.http.nio.reactor.IOSession;

class InternalIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final Log log = LogFactory.getLog(InternalIODispatch.class);
    private final NHttpClientEventHandler handler;

    public InternalIODispatch(NHttpClientEventHandler handler) {
        this.handler = this.log.isDebugEnabled() ? new InternalRequestExecutor(this.log, handler) : handler;
    }

    @Override
    protected DefaultNHttpClientConnection createConnection(IOSession session) {
        throw new IllegalStateException("Connection must be created by connection manager");
    }

    @Override
    protected void onConnected(DefaultNHttpClientConnection conn) {
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected(conn, attachment);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpClientConnection conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(DefaultNHttpClientConnection conn, IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(DefaultNHttpClientConnection conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpClientConnection conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpClientConnection conn) {
        try {
            this.handler.timeout(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }
}

