/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.auth;

import rp.org.apache.http.annotation.Immutable;
import rp.org.apache.http.auth.AuthScheme;
import rp.org.apache.http.auth.AuthSchemeFactory;
import rp.org.apache.http.auth.AuthSchemeProvider;
import rp.org.apache.http.impl.auth.SPNegoScheme;
import rp.org.apache.http.params.HttpParams;
import rp.org.apache.http.protocol.HttpContext;

@Immutable
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public SPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public SPNegoSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public SPNegoSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }
}

