/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.client.protocol;

import java.io.IOException;
import rp.org.apache.http.HttpEntity;
import rp.org.apache.http.HttpEntityEnclosingRequest;
import rp.org.apache.http.HttpException;
import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.HttpRequestInterceptor;
import rp.org.apache.http.HttpVersion;
import rp.org.apache.http.ProtocolVersion;
import rp.org.apache.http.annotation.Immutable;
import rp.org.apache.http.client.config.RequestConfig;
import rp.org.apache.http.client.protocol.HttpClientContext;
import rp.org.apache.http.protocol.HttpContext;
import rp.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

