/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.collect.ImmutableList;
import rp.com.google.common.collect.ImmutableMap;
import rp.com.google.common.collect.Iterables;
import rp.com.google.common.collect.ListMultimap;
import rp.com.google.common.collect.Lists;
import rp.com.google.common.collect.Maps;
import rp.com.google.inject.Key;
import rp.com.google.inject.Provider;
import rp.com.google.inject.ProvisionException;
import rp.com.google.inject.Scope;
import rp.com.google.inject.Scopes;
import rp.com.google.inject.internal.ConstructionContext;
import rp.com.google.inject.internal.CycleDetectingLock;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.ErrorsException;
import rp.com.google.inject.internal.InjectorImpl;
import rp.com.google.inject.internal.InternalContext;
import rp.com.google.inject.spi.Dependency;
import rp.com.google.inject.spi.DependencyAndSource;
import rp.com.google.inject.spi.Message;

public class SingletonScope
implements Scope {
    private static final Object NULL = new Object();
    static final ThreadLocal<WeakReference<InjectorImpl>> currentInjector = new ThreadLocal();
    private static final ConcurrentMap<Thread, InternalContext> internalContextsMap = Maps.newConcurrentMap();
    private static final CycleDetectingLock.CycleDetectingLockFactory<Key<?>> cycleDetectingLockFactory = new CycleDetectingLock.CycleDetectingLockFactory();

    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){
            volatile Object instance;
            final ConstructionContext<T> constructionContext = new ConstructionContext();
            final CycleDetectingLock<Key<?>> creationLock = SingletonScope.access$000().create(key);
            final InjectorImpl injector = (InjectorImpl)currentInjector.get().get();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T get() {
                Object object;
                Object initialInstance = this.instance;
                if (initialInstance == null) {
                    Object object2;
                    block30: {
                        Thread currentThread = Thread.currentThread();
                        InternalContext context = this.injector.getLocalContext();
                        InternalContext previousContext = (InternalContext)internalContextsMap.get(currentThread);
                        internalContextsMap.put(currentThread, context);
                        try {
                            ListMultimap<Long, Key<?>> locksCycle = this.creationLock.lockOrDetectPotentialLocksCycle();
                            if (locksCycle.isEmpty()) {
                                Object providedNotNull;
                                try {
                                    if (this.instance != null) break block30;
                                    Object provided = creator.get();
                                    Object object3 = providedNotNull = provided == null ? NULL : provided;
                                    if (this.instance == null) {
                                        if (Scopes.isCircularProxy(provided)) {
                                            Object t = provided;
                                            return t;
                                        }
                                        ConstructionContext constructionContext = this.constructionContext;
                                        synchronized (constructionContext) {
                                            this.instance = providedNotNull;
                                            this.constructionContext.setProxyDelegates(provided);
                                            break block30;
                                        }
                                    } else {
                                        Preconditions.checkState(this.instance == providedNotNull, "Singleton is called recursively returning different results");
                                    }
                                    break block30;
                                }
                                catch (RuntimeException e) {
                                    providedNotNull = this.constructionContext;
                                    synchronized (providedNotNull) {
                                        this.constructionContext.finishConstruction();
                                        throw e;
                                    }
                                }
                                finally {
                                    this.creationLock.unlock();
                                }
                            }
                            ConstructionContext e = this.constructionContext;
                            synchronized (e) {
                                if (this.instance == null) {
                                    Dependency<?> dependency = Preconditions.checkNotNull(context.getDependency(), "internalContext.getDependency()");
                                    Class<?> rawType = dependency.getKey().getTypeLiteral().getRawType();
                                    try {
                                        Object proxy;
                                        Object object4 = proxy = this.constructionContext.createProxy(new Errors(), context.getInjectorOptions(), rawType);
                                        return object4;
                                    }
                                    catch (ErrorsException e2) {
                                        Message proxyCreationError = Iterables.getOnlyElement(e2.getErrors().getMessages());
                                        Message cycleDependenciesMessage = this.createCycleDependenciesMessage(ImmutableMap.copyOf(internalContextsMap), locksCycle, proxyCreationError);
                                        throw new ProvisionException(ImmutableList.of(cycleDependenciesMessage, proxyCreationError));
                                    }
                                }
                            }
                        }
                        finally {
                            if (previousContext != null) {
                                internalContextsMap.put(currentThread, previousContext);
                            } else {
                                internalContextsMap.remove(currentThread);
                            }
                        }
                    }
                    Object initializedInstance = this.instance;
                    Preconditions.checkState(initializedInstance != null, "Internal error: Singleton is not initialized contrary to our expectations");
                    Object initializedTypedInstance = initializedInstance;
                    if (initializedInstance == NULL) {
                        object2 = null;
                        return object2;
                    }
                    object2 = initializedTypedInstance;
                    return object2;
                }
                Object typedInitialIntance = initialInstance;
                if (initialInstance == NULL) {
                    object = null;
                    return object;
                }
                object = typedInitialIntance;
                return object;
            }

            private Message createCycleDependenciesMessage(Map<Thread, InternalContext> internalContextsMap, ListMultimap<Long, Key<?>> locksCycle, Message proxyCreationError) {
                ArrayList<Object> sourcesCycle = Lists.newArrayList();
                sourcesCycle.add(Thread.currentThread());
                HashMap<Long, Thread> threadById = Maps.newHashMap();
                for (Thread thread : internalContextsMap.keySet()) {
                    threadById.put(thread.getId(), thread);
                }
                Iterator<Thread> iterator = locksCycle.keySet().iterator();
                while (iterator.hasNext()) {
                    long lockedThreadId = (Long)((Object)iterator.next());
                    Thread lockedThread = (Thread)threadById.get(lockedThreadId);
                    List<Key<?>> lockedKeys = Collections.unmodifiableList(locksCycle.get(lockedThreadId));
                    if (lockedThread == null) continue;
                    List<DependencyAndSource> dependencyChain = null;
                    boolean allLockedKeysAreFoundInDependencies = false;
                    InternalContext lockedThreadInternalContext = internalContextsMap.get(lockedThread);
                    if (lockedThreadInternalContext != null) {
                        dependencyChain = lockedThreadInternalContext.getDependencyChain();
                        LinkedList<Key<?>> lockedKeysToFind = Lists.newLinkedList(lockedKeys);
                        for (DependencyAndSource d : dependencyChain) {
                            Dependency<?> dependency = d.getDependency();
                            if (dependency == null || !dependency.getKey().equals(lockedKeysToFind.get(0))) continue;
                            lockedKeysToFind.remove(0);
                            if (!lockedKeysToFind.isEmpty()) continue;
                            allLockedKeysAreFoundInDependencies = true;
                            break;
                        }
                    }
                    if (allLockedKeysAreFoundInDependencies) {
                        Key<?> firstLockedKey = lockedKeys.get(0);
                        boolean firstLockedKeyFound = false;
                        for (DependencyAndSource d : dependencyChain) {
                            Dependency<?> dependency = d.getDependency();
                            if (dependency == null) continue;
                            if (firstLockedKeyFound) {
                                sourcesCycle.add(dependency);
                                sourcesCycle.add(d.getBindingSource());
                                continue;
                            }
                            if (!dependency.getKey().equals(firstLockedKey)) continue;
                            firstLockedKeyFound = true;
                            sourcesCycle.add(d.getBindingSource());
                        }
                    } else {
                        sourcesCycle.addAll(lockedKeys);
                    }
                    sourcesCycle.add(lockedThread);
                }
                return new Message(sourcesCycle, String.format("Encountered circular dependency spanning several threads. %s", proxyCreationError.getMessage()), null);
            }

            public String toString() {
                return String.format("%s[%s]", creator, Scopes.SINGLETON);
            }
        };
    }

    @Override
    public String toString() {
        return "Scopes.SINGLETON";
    }

    static /* synthetic */ CycleDetectingLock.CycleDetectingLockFactory access$000() {
        return cycleDetectingLockFactory;
    }
}

