/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import rp.com.google.inject.internal.BytecodeGen;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.ErrorsException;
import rp.com.google.inject.internal.InjectorImpl;
import rp.com.google.inject.internal.InternalContext;
import rp.com.google.inject.internal.SingleMemberInjector;
import rp.com.google.inject.internal.SingleParameterInjector;
import rp.com.google.inject.internal.cglib.core.$CodeGenerationException;
import rp.com.google.inject.internal.cglib.reflect.$FastClass;
import rp.com.google.inject.spi.InjectionPoint;

final class SingleMethodInjector
implements SingleMemberInjector {
    private final InjectorImpl.MethodInvoker methodInvoker;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final InjectionPoint injectionPoint;

    SingleMethodInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        Method method = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method);
        this.parameterInjectors = injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method) {
        try {
            final $FastClass fastClass = BytecodeGen.newFastClassForMember(method);
            if (fastClass != null) {
                final int index = fastClass.getMethod(method).getIndex();
                return new InjectorImpl.MethodInvoker(){

                    @Override
                    public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                        return fastClass.invoke(index, target, parameters);
                    }
                };
            }
        }
        catch ($CodeGenerationException fastClass) {
            // empty catch block
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new InjectorImpl.MethodInvoker(){

            @Override
            public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                return method.invoke(target, parameters);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(Errors errors, InternalContext context, Object o) {
        Object[] parameters;
        try {
            parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
            return;
        }
        try {
            this.methodInvoker.invoke(o, parameters);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            errors.withSource(this.injectionPoint).errorInjectingMethod(cause);
        }
    }
}

