/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import javax.inject.Provider;
import rp.com.google.common.base.Preconditions;
import rp.com.google.inject.internal.ConstructionContext;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.ErrorsException;
import rp.com.google.inject.internal.InternalContext;
import rp.com.google.inject.internal.InternalFactory;
import rp.com.google.inject.internal.ProvisionListenerStackCallback;
import rp.com.google.inject.spi.Dependency;

abstract class ProviderInternalFactory<T>
implements InternalFactory<T> {
    protected final Object source;

    ProviderInternalFactory(Object source) {
        this.source = Preconditions.checkNotNull(source, "source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T circularGet(final Provider<? extends T> provider, final Errors errors, InternalContext context, final Dependency<?> dependency, ProvisionListenerStackCallback<T> provisionCallback) throws ErrorsException {
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            Class<?> expectedType = dependency.getKey().getTypeLiteral().getRawType();
            Object proxyType = constructionContext.createProxy(errors, context.getInjectorOptions(), expectedType);
            return (T)proxyType;
        }
        constructionContext.startConstruction();
        try {
            if (!provisionCallback.hasListeners()) {
                T t = this.provision(provider, errors, dependency, constructionContext);
                return t;
            }
            T t = provisionCallback.provision(errors, context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws ErrorsException {
                    return ProviderInternalFactory.this.provision(provider, errors, dependency, constructionContext);
                }
            });
            return t;
        }
        finally {
            constructionContext.removeCurrentReference();
            constructionContext.finishConstruction();
        }
    }

    protected T provision(Provider<? extends T> provider, Errors errors, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws ErrorsException {
        Object t = errors.checkForNull(provider.get(), this.source, dependency);
        constructionContext.setProxyDelegates(t);
        return (T)t;
    }
}

