/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import rp.com.google.inject.Provider;
import rp.com.google.inject.internal.AbstractProcessor;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.ErrorsException;
import rp.com.google.inject.internal.MembersInjectorImpl;
import rp.com.google.inject.spi.MembersInjectorLookup;
import rp.com.google.inject.spi.ProviderLookup;

final class LookupProcessor
extends AbstractProcessor {
    LookupProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        try {
            MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(lookup.getType(), this.errors);
            lookup.initializeDelegate(membersInjector);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        try {
            Provider<T> provider = this.injector.getProviderOrThrow(lookup.getDependency(), this.errors);
            lookup.initializeDelegate(provider);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }
}

