/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import javax.inject.Provider;
import rp.com.google.common.base.Preconditions;
import rp.com.google.inject.internal.ConstructionContext;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.ErrorsException;
import rp.com.google.inject.internal.Initializable;
import rp.com.google.inject.internal.InternalContext;
import rp.com.google.inject.internal.ProviderInternalFactory;
import rp.com.google.inject.internal.ProvisionListenerStackCallback;
import rp.com.google.inject.spi.Dependency;

final class InternalFactoryToInitializableAdapter<T>
extends ProviderInternalFactory<T> {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final Initializable<? extends Provider<? extends T>> initializable;

    public InternalFactoryToInitializableAdapter(Initializable<? extends Provider<? extends T>> initializable, Object source, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source);
        this.provisionCallback = Preconditions.checkNotNull(provisionCallback, "provisionCallback");
        this.initializable = Preconditions.checkNotNull(initializable, "provider");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        return this.circularGet(this.initializable.get(errors), errors, context, dependency, this.provisionCallback);
    }

    @Override
    protected T provision(Provider<? extends T> provider, Errors errors, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws ErrorsException {
        try {
            return super.provision(provider, errors, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

