/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.collect.ImmutableSet;
import rp.com.google.common.collect.Lists;
import rp.com.google.inject.Binder;
import rp.com.google.inject.Injector;
import rp.com.google.inject.Key;
import rp.com.google.inject.Module;
import rp.com.google.inject.Provider;
import rp.com.google.inject.Scopes;
import rp.com.google.inject.Singleton;
import rp.com.google.inject.Stage;
import rp.com.google.inject.internal.BindingProcessor;
import rp.com.google.inject.internal.ConstantFactory;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.ErrorsException;
import rp.com.google.inject.internal.InheritingState;
import rp.com.google.inject.internal.Initializables;
import rp.com.google.inject.internal.Initializer;
import rp.com.google.inject.internal.InjectorImpl;
import rp.com.google.inject.internal.InjectorOptionsProcessor;
import rp.com.google.inject.internal.InstanceBindingImpl;
import rp.com.google.inject.internal.InterceptorBindingProcessor;
import rp.com.google.inject.internal.InternalContext;
import rp.com.google.inject.internal.InternalFactory;
import rp.com.google.inject.internal.ListenerBindingProcessor;
import rp.com.google.inject.internal.MembersInjectorStore;
import rp.com.google.inject.internal.MessageProcessor;
import rp.com.google.inject.internal.ModuleAnnotatedMethodScannerProcessor;
import rp.com.google.inject.internal.PrivateElementProcessor;
import rp.com.google.inject.internal.PrivateElementsImpl;
import rp.com.google.inject.internal.ProcessedBindingData;
import rp.com.google.inject.internal.ProviderInstanceBindingImpl;
import rp.com.google.inject.internal.ProvisionListenerCallbackStore;
import rp.com.google.inject.internal.ScopeBindingProcessor;
import rp.com.google.inject.internal.Scoping;
import rp.com.google.inject.internal.State;
import rp.com.google.inject.internal.TypeConverterBindingProcessor;
import rp.com.google.inject.internal.UntargettedBindingProcessor;
import rp.com.google.inject.internal.util.SourceProvider;
import rp.com.google.inject.internal.util.Stopwatch;
import rp.com.google.inject.spi.Dependency;
import rp.com.google.inject.spi.Element;
import rp.com.google.inject.spi.Elements;
import rp.com.google.inject.spi.InjectionPoint;
import rp.com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import rp.com.google.inject.spi.PrivateElements;
import rp.com.google.inject.spi.ProvisionListenerBinding;
import rp.com.google.inject.spi.TypeListenerBinding;

final class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;

    private InjectorShell(Builder builder, List<Element> elements, InjectorImpl injector) {
        this.elements = elements;
        this.injector = injector;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injector) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injector);
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Injector>(injector, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, ImmutableSet.<InjectionPoint>of()));
    }

    private static void bindLogger(InjectorImpl injector) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Logger>(injector, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, ImmutableSet.<InjectionPoint>of()));
    }

    private static void bindStage(InjectorImpl injector, Stage stage) {
        Key<Stage> key = Key.get(Stage.class);
        InstanceBindingImpl<Stage> stageBinding = new InstanceBindingImpl<Stage>(injector, key, SourceProvider.UNKNOWN_SOURCE, new ConstantFactory<Stage>(Initializables.of(stage)), ImmutableSet.<InjectionPoint>of(), stage);
        injector.state.putBinding(key, stageBinding);
    }

    private static class InheritedScannersModule
    implements Module {
        private final State state;

        InheritedScannersModule(State state) {
            this.state = state;
        }

        @Override
        public void configure(Binder binder) {
            for (ModuleAnnotatedMethodScannerBinding binding : this.state.getScannerBindings()) {
                binding.applyTo(binder);
            }
        }
    }

    private static class RootModule
    implements Module {
        private RootModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.withSource(SourceProvider.UNKNOWN_SOURCE);
            binder.bindScope(Singleton.class, Scopes.SINGLETON);
            binder.bindScope(javax.inject.Singleton.class, Scopes.SINGLETON);
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Provider<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "Provider<Logger>";
        }
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Provider<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "Provider<Injector>";
        }
    }

    static class Builder {
        private final List<Element> elements = Lists.newArrayList();
        private final List<Module> modules = Lists.newArrayList();
        private State state;
        private InjectorImpl parent;
        private InjectorImpl.InjectorOptions options;
        private Stage stage;
        private PrivateElementsImpl privateElements;

        Builder() {
        }

        Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        Builder parent(InjectorImpl parent) {
            this.parent = parent;
            this.state = new InheritingState(parent.state);
            this.options = parent.options;
            this.stage = this.options.stage;
            return this;
        }

        Builder privateElements(PrivateElements privateElements) {
            this.privateElements = (PrivateElementsImpl)privateElements;
            this.elements.addAll(privateElements.getElements());
            return this;
        }

        void addModules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        Stage getStage() {
            return this.options.stage;
        }

        Object lock() {
            return this.getState().lock();
        }

        List<InjectorShell> build(Initializer initializer, ProcessedBindingData bindingData, Stopwatch stopwatch, Errors errors) {
            Preconditions.checkState(this.stage != null, "Stage not initialized");
            Preconditions.checkState(this.privateElements == null || this.parent != null, "PrivateElements with no parent");
            Preconditions.checkState(this.state != null, "no state. Did you remember to lock() ?");
            if (this.parent == null) {
                this.modules.add(0, new RootModule());
            } else {
                this.modules.add(0, new InheritedScannersModule(this.parent.state));
            }
            this.elements.addAll(Elements.getElements(this.stage, this.modules));
            InjectorOptionsProcessor optionsProcessor = new InjectorOptionsProcessor(errors);
            optionsProcessor.process(null, this.elements);
            this.options = optionsProcessor.getOptions(this.stage, this.options);
            InjectorImpl injector = new InjectorImpl(this.parent, this.state, this.options);
            if (this.privateElements != null) {
                this.privateElements.initInjector(injector);
            }
            if (this.parent == null) {
                TypeConverterBindingProcessor.prepareBuiltInConverters(injector);
            }
            stopwatch.resetAndLog("Module execution");
            new MessageProcessor(errors).process(injector, this.elements);
            new InterceptorBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Interceptors creation");
            new ListenerBindingProcessor(errors).process(injector, this.elements);
            List<TypeListenerBinding> typeListenerBindings = injector.state.getTypeListenerBindings();
            injector.membersInjectorStore = new MembersInjectorStore(injector, typeListenerBindings);
            List<ProvisionListenerBinding> provisionListenerBindings = injector.state.getProvisionListenerBindings();
            injector.provisionListenerStore = new ProvisionListenerCallbackStore(provisionListenerBindings);
            stopwatch.resetAndLog("TypeListeners & ProvisionListener creation");
            new ScopeBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Converters creation");
            InjectorShell.bindStage(injector, this.stage);
            InjectorShell.bindInjector(injector);
            InjectorShell.bindLogger(injector);
            new BindingProcessor(errors, initializer, bindingData).process(injector, this.elements);
            new UntargettedBindingProcessor(errors, bindingData).process(injector, this.elements);
            stopwatch.resetAndLog("Binding creation");
            new ModuleAnnotatedMethodScannerProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("Module annotated method scanners creation");
            ArrayList<InjectorShell> injectorShells = Lists.newArrayList();
            injectorShells.add(new InjectorShell(this, this.elements, injector));
            PrivateElementProcessor processor = new PrivateElementProcessor(errors);
            processor.process(injector, this.elements);
            for (Builder builder : processor.getInjectorShellBuilders()) {
                injectorShells.addAll(builder.build(initializer, bindingData, stopwatch, errors));
            }
            stopwatch.resetAndLog("Private environment creation");
            return injectorShells;
        }

        private State getState() {
            if (this.state == null) {
                this.state = new InheritingState(State.NONE);
            }
            return this.state;
        }
    }
}

