/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import java.util.Set;
import rp.com.google.common.base.MoreObjects;
import rp.com.google.common.collect.ImmutableSet;
import rp.com.google.inject.Binder;
import rp.com.google.inject.Injector;
import rp.com.google.inject.Key;
import rp.com.google.inject.internal.BindingImpl;
import rp.com.google.inject.internal.InjectorImpl;
import rp.com.google.inject.internal.InternalFactory;
import rp.com.google.inject.internal.Scoping;
import rp.com.google.inject.spi.BindingTargetVisitor;
import rp.com.google.inject.spi.Dependency;
import rp.com.google.inject.spi.ExposedBinding;
import rp.com.google.inject.spi.PrivateElements;

public final class ExposedBindingImpl<T>
extends BindingImpl<T>
implements ExposedBinding<T> {
    private final PrivateElements privateElements;

    public ExposedBindingImpl(InjectorImpl injector, Object source, Key<T> key, InternalFactory<T> factory, PrivateElements privateElements) {
        super(injector, key, source, factory, Scoping.UNSCOPED);
        this.privateElements = privateElements;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
    }

    @Override
    public PrivateElements getPrivateElements() {
        return this.privateElements;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ExposedBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("privateElements", this.privateElements).toString();
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }
}

