/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import java.util.List;
import rp.com.google.common.collect.Lists;
import rp.com.google.inject.Key;
import rp.com.google.inject.MembersInjector;
import rp.com.google.inject.Provider;
import rp.com.google.inject.TypeLiteral;
import rp.com.google.inject.internal.Errors;
import rp.com.google.inject.internal.InjectorImpl;
import rp.com.google.inject.internal.LookupProcessor;
import rp.com.google.inject.internal.Lookups;
import rp.com.google.inject.spi.Element;
import rp.com.google.inject.spi.MembersInjectorLookup;
import rp.com.google.inject.spi.ProviderLookup;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

