/*
 * Decompiled with CFR 0.152.
 */
package rp.com.google.inject.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.collect.ImmutableListMultimap;
import rp.com.google.common.collect.LinkedHashMultimap;
import rp.com.google.common.collect.ListMultimap;
import rp.com.google.common.collect.Lists;
import rp.com.google.common.collect.Maps;
import rp.com.google.common.collect.Multimap;
import rp.com.google.common.collect.Multimaps;

interface CycleDetectingLock<ID> {
    public ListMultimap<Long, ID> lockOrDetectPotentialLocksCycle();

    public void unlock();

    public static class CycleDetectingLockFactory<ID> {
        private static Map<Long, ReentrantCycleDetectingLock<?>> lockThreadIsWaitingOn = Maps.newHashMap();
        private static final Multimap<Long, ReentrantCycleDetectingLock<?>> locksOwnedByThread = LinkedHashMultimap.create();

        CycleDetectingLock<ID> create(ID userLockId) {
            return new ReentrantCycleDetectingLock<ID>(this, userLockId, new ReentrantLock());
        }

        static class ReentrantCycleDetectingLock<ID>
        implements CycleDetectingLock<ID> {
            private final Lock lockImplementation;
            private final ID userLockId;
            private final CycleDetectingLockFactory<ID> lockFactory;
            private Long lockOwnerThreadId = null;
            private int lockReentranceCount = 0;

            ReentrantCycleDetectingLock(CycleDetectingLockFactory<ID> lockFactory, ID userLockId, Lock lockImplementation) {
                this.lockFactory = lockFactory;
                this.userLockId = Preconditions.checkNotNull(userLockId, "userLockId");
                this.lockImplementation = Preconditions.checkNotNull(lockImplementation, "lockImplementation");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListMultimap<Long, ID> lockOrDetectPotentialLocksCycle() {
                long currentThreadId = Thread.currentThread().getId();
                Class<CycleDetectingLockFactory> clazz = CycleDetectingLockFactory.class;
                synchronized (CycleDetectingLockFactory.class) {
                    this.checkState();
                    ListMultimap<Long, ID> locksInCycle = this.detectPotentialLocksCycle();
                    if (!locksInCycle.isEmpty()) {
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return locksInCycle;
                    }
                    lockThreadIsWaitingOn.put(currentThreadId, this);
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    this.lockImplementation.lock();
                    clazz = CycleDetectingLockFactory.class;
                    synchronized (CycleDetectingLockFactory.class) {
                        lockThreadIsWaitingOn.remove(currentThreadId);
                        this.checkState();
                        this.lockOwnerThreadId = currentThreadId;
                        ++this.lockReentranceCount;
                        locksOwnedByThread.put(currentThreadId, this);
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return ImmutableListMultimap.of();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlock() {
                long currentThreadId = Thread.currentThread().getId();
                Class<CycleDetectingLockFactory> clazz = CycleDetectingLockFactory.class;
                synchronized (CycleDetectingLockFactory.class) {
                    this.checkState();
                    Preconditions.checkState(this.lockOwnerThreadId != null, "Thread is trying to unlock a lock that is not locked");
                    Preconditions.checkState(this.lockOwnerThreadId == currentThreadId, "Thread is trying to unlock a lock owned by another thread");
                    this.lockImplementation.unlock();
                    --this.lockReentranceCount;
                    if (this.lockReentranceCount == 0) {
                        this.lockOwnerThreadId = null;
                        Preconditions.checkState(locksOwnedByThread.remove(currentThreadId, this), "Internal error: Can not find this lock in locks owned by a current thread");
                        if (locksOwnedByThread.get(currentThreadId).isEmpty()) {
                            locksOwnedByThread.removeAll(currentThreadId);
                        }
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
            }

            void checkState() throws IllegalStateException {
                long currentThreadId = Thread.currentThread().getId();
                Preconditions.checkState(!lockThreadIsWaitingOn.containsKey(currentThreadId), "Internal error: Thread should not be in a waiting thread on a lock now");
                if (this.lockOwnerThreadId != null) {
                    Preconditions.checkState(this.lockReentranceCount >= 0, "Internal error: Lock ownership and reentrance count internal states do not match");
                    Preconditions.checkState(locksOwnedByThread.get(this.lockOwnerThreadId).contains(this), "Internal error: Set of locks owned by a current thread and lock ownership status do not match");
                } else {
                    Preconditions.checkState(this.lockReentranceCount == 0, "Internal error: Reentrance count of a non locked lock is expect to be zero");
                    Preconditions.checkState(!locksOwnedByThread.values().contains(this), "Internal error: Non locked lock should not be owned by any thread");
                }
            }

            private ListMultimap<Long, ID> detectPotentialLocksCycle() {
                long currentThreadId = Thread.currentThread().getId();
                if (this.lockOwnerThreadId == null || this.lockOwnerThreadId == currentThreadId) {
                    return ImmutableListMultimap.of();
                }
                ListMultimap<Long, ID> potentialLocksCycle = Multimaps.newListMultimap(new LinkedHashMap(), new Supplier<List<ID>>(){

                    @Override
                    public List<ID> get() {
                        return Lists.newArrayList();
                    }
                });
                ReentrantCycleDetectingLock lockOwnerWaitingOn = this;
                while (lockOwnerWaitingOn != null && lockOwnerWaitingOn.lockOwnerThreadId != null) {
                    Long threadOwnerThreadWaits = lockOwnerWaitingOn.lockOwnerThreadId;
                    potentialLocksCycle.putAll(threadOwnerThreadWaits, this.getAllLockIdsAfter(threadOwnerThreadWaits, lockOwnerWaitingOn));
                    if (threadOwnerThreadWaits == currentThreadId) {
                        return potentialLocksCycle;
                    }
                    lockOwnerWaitingOn = (ReentrantCycleDetectingLock)lockThreadIsWaitingOn.get(threadOwnerThreadWaits);
                }
                return ImmutableListMultimap.of();
            }

            private List<ID> getAllLockIdsAfter(long threadId, ReentrantCycleDetectingLock lock) {
                ArrayList<ID> ids = Lists.newArrayList();
                boolean found = false;
                Collection ownedLocks = locksOwnedByThread.get(threadId);
                Preconditions.checkNotNull(ownedLocks, "Internal error: No locks were found taken by a thread");
                for (ReentrantCycleDetectingLock ownedLock : ownedLocks) {
                    if (ownedLock == lock) {
                        found = true;
                    }
                    if (!found || ownedLock.lockFactory != this.lockFactory) continue;
                    ID userLockId = ownedLock.userLockId;
                    ids.add(userLockId);
                }
                Preconditions.checkState(found, "Internal error: We can not find locks that created a cycle that we detected");
                return ids;
            }

            public String toString() {
                Long threadId = this.lockOwnerThreadId;
                if (threadId != null) {
                    return String.format("%s[%s][locked by Id=%d]", super.toString(), this.userLockId, threadId);
                }
                return String.format("%s[%s][unlocked]", super.toString(), this.userLockId);
            }
        }
    }
}

