/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.serializer.xml;

import com.epam.restendpoint.http.IOUtils;
import com.epam.restendpoint.http.exception.SerializerException;
import com.epam.restendpoint.serializer.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import rp.com.google.common.net.MediaType;
import rp.com.google.common.reflect.TypeToken;

public class JaxbSerializer
implements Serializer {
    private final JAXBContext jaxbContext;

    public JaxbSerializer(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public JaxbSerializer(Class ... classes) throws SerializerException {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            throw new SerializerException("Unable to create JaxbContext", e);
        }
    }

    public JaxbSerializer(String contextPath) throws SerializerException {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)contextPath);
        }
        catch (JAXBException e) {
            throw new SerializerException("Unable to create JaxbContext", e);
        }
    }

    @Override
    public <T> byte[] serialize(T t) throws SerializerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StreamResult result = new StreamResult(baos);
            this.jaxbContext.createMarshaller().marshal(t, (Result)result);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (JAXBException e) {
            throw new SerializerException("Unable to serialize xml", e);
        }
        finally {
            IOUtils.closeQuietly(baos);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Class<T> clazz) throws SerializerException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            JAXBElement result = this.jaxbContext.createUnmarshaller().unmarshal((Source)new StreamSource(is), clazz);
            return (T)result.getValue();
        }
        catch (JAXBException e) {
            throw new SerializerException("Unable to deserialize xml", e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Type type) throws SerializerException {
        return (T)this.deserialize(content, TypeToken.of(type).getRawType());
    }

    @Override
    public String getMimeType() {
        return MediaType.APPLICATION_XML_UTF_8.toString();
    }

    @Override
    public boolean canRead(MediaType mimeType, Class<?> resultType) {
        return this.canRead(mimeType, TypeToken.of(resultType).getType());
    }

    @Override
    public boolean canRead(MediaType mimeType, Type resultType) {
        return mimeType.withoutParameters().is(MediaType.APPLICATION_XML_UTF_8.withoutParameters());
    }

    @Override
    public boolean canWrite(Object o) {
        return null != o && o.getClass().isAnnotationPresent(XmlRootElement.class);
    }
}

