/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.serializer.json;

import com.epam.restendpoint.http.exception.SerializerException;
import com.epam.restendpoint.serializer.json.AbstractJsonSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;

public class JacksonSerializer
extends AbstractJsonSerializer {
    private final ObjectMapper objectMapper;

    public JacksonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonSerializer() {
        this(new ObjectMapper());
    }

    @Override
    public <T> byte[] serialize(T t) throws SerializerException {
        try {
            return this.objectMapper.writeValueAsBytes(t);
        }
        catch (JsonProcessingException e) {
            throw new SerializerException("Unable to serialize content", e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Class<T> clazz) throws SerializerException {
        try {
            return (T)this.objectMapper.readValue(content, clazz);
        }
        catch (IOException e) {
            throw new SerializerException("Unable to deserialize content", e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Type type) throws SerializerException {
        try {
            return (T)this.objectMapper.readValue(content, this.objectMapper.getTypeFactory().constructType(type));
        }
        catch (IOException e) {
            throw new SerializerException("Unable to deserialize content", e);
        }
    }
}

