/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.serializer.json;

import com.epam.restendpoint.http.IOUtils;
import com.epam.restendpoint.http.exception.SerializerException;
import com.epam.restendpoint.serializer.json.AbstractJsonSerializer;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import rp.com.google.common.base.Charsets;
import rp.com.google.common.io.ByteSource;

public class GsonSerializer
extends AbstractJsonSerializer {
    private final Gson gson;

    public GsonSerializer(Gson gson) {
        this.gson = gson;
    }

    public GsonSerializer() {
        this(new Gson());
    }

    @Override
    public <T> byte[] serialize(T t) throws SerializerException {
        try {
            return this.gson.toJson(t).getBytes(Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializerException("UTF-8 is not supported", e);
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Class<T> clazz) throws SerializerException {
        Object object;
        BufferedReader is = null;
        try {
            is = ByteSource.wrap(content).asCharSource(Charsets.UTF_8).openBufferedStream();
            object = this.gson.fromJson((Reader)is, clazz);
        }
        catch (IOException e) {
            try {
                throw new SerializerException("Unable to serialize content", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return (T)object;
    }

    @Override
    public <T> T deserialize(byte[] content, Type type) throws SerializerException {
        try {
            return (T)this.gson.getAdapter(TypeToken.get((Type)type)).fromJson((Reader)ByteSource.wrap(content).asCharSource(Charsets.UTF_8).openBufferedStream());
        }
        catch (IOException e) {
            throw new SerializerException("Unable to serialize content", e);
        }
    }
}

