/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.http.proxy;

import com.epam.restendpoint.http.HttpMethod;
import com.epam.restendpoint.http.MultiPartRequest;
import com.epam.restendpoint.http.Response;
import com.epam.restendpoint.http.RestCommand;
import com.epam.restendpoint.http.annotation.Body;
import com.epam.restendpoint.http.annotation.Multipart;
import com.epam.restendpoint.http.annotation.Path;
import com.epam.restendpoint.http.annotation.Query;
import com.epam.restendpoint.http.annotation.Request;
import com.epam.restendpoint.http.uri.UrlTemplate;
import io.reactivex.Maybe;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rp.com.google.common.base.Joiner;
import rp.com.google.common.base.Optional;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.collect.ImmutableList;
import rp.com.google.common.collect.Sets;
import rp.com.google.common.reflect.Invokable;
import rp.com.google.common.reflect.Parameter;
import rp.com.google.common.reflect.TypeToken;

class RestMethodInfo {
    private final Map<Integer, String> pathArguments = new LinkedHashMap<Integer, String>();
    private HttpMethod method;
    private Type responseType;
    private boolean asynchronous;
    private UrlTemplate urlTemplate;
    private Optional<Integer> bodyArgument = Optional.absent();
    private Optional<Integer> queryParameter = Optional.absent();
    private boolean returnBodyOnly;
    private boolean multiPart;

    @Nonnull
    public static Map<Method, RestMethodInfo> mapMethods(@Nonnull Class<?> clazz) {
        HashMap<Method, RestMethodInfo> methodInfo = new HashMap<Method, RestMethodInfo>();
        for (Method method : clazz.getMethods()) {
            if (!RestMethodInfo.isRestMethodDefinition(method)) continue;
            methodInfo.put(method, new RestMethodInfo(method));
        }
        return methodInfo;
    }

    static boolean isRestMethodDefinition(Method m) {
        return m.isAnnotationPresent(Request.class);
    }

    static boolean isAsynchronous(Invokable<?, ?> method) {
        return Maybe.class.isAssignableFrom(method.getReturnType().getRawType());
    }

    static boolean bodyOnly(Invokable<?, ?> method) {
        return !Response.class.equals(method.getReturnType().getRawType());
    }

    static Type getResponseType(Invokable<?, ?> method) {
        Type returnType;
        if (RestMethodInfo.isAsynchronous(method)) {
            Type[] genericArgs = RestMethodInfo.getGenericTypeArguments(method.getReturnType());
            returnType = Response.class.equals((Object)genericArgs[0]) ? genericArgs[1] : genericArgs[0];
        } else if (!RestMethodInfo.bodyOnly(method)) {
            Type[] genericArgs = RestMethodInfo.getGenericTypeArguments(method.getReturnType());
            returnType = genericArgs[0];
        } else {
            returnType = method.getReturnType().getType();
        }
        return returnType;
    }

    public RestMethodInfo(Method m) {
        this.parseMethod(Invokable.from(m));
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public boolean isBodyOnly() {
        return this.returnBodyOnly;
    }

    private void parseMethod(Invokable<?, ?> method) {
        Request request = method.getAnnotation(Request.class);
        this.urlTemplate = UrlTemplate.create(request.url());
        this.asynchronous = RestMethodInfo.isAsynchronous(method);
        this.method = request.method();
        this.responseType = RestMethodInfo.getResponseType(method);
        this.returnBodyOnly = RestMethodInfo.bodyOnly(method);
        ImmutableList<Parameter> methodParameters = method.getParameters();
        for (int i = 0; i < methodParameters.size(); ++i) {
            Parameter parameter = (Parameter)methodParameters.get(i);
            if (parameter.isAnnotationPresent(Path.class)) {
                Path path = parameter.getAnnotation(Path.class);
                assert (path != null);
                Preconditions.checkState(this.urlTemplate.hasPathVariable(path.value()), "There is no path parameter with name '%s' declared in url template", (Object)path.value());
                this.pathArguments.put(i, path.value());
                continue;
            }
            if (parameter.isAnnotationPresent(Body.class)) {
                this.bodyArgument = Optional.of(i);
                if (!parameter.isAnnotationPresent(Multipart.class)) continue;
                Preconditions.checkArgument(TypeToken.of(MultiPartRequest.class).isSupertypeOf(parameter.getType()), "@Multipart parameters are expected to be MultiPartRequest. '%s' is not a MultiPartRequest", parameter.getType());
                this.multiPart = true;
                continue;
            }
            if (!parameter.isAnnotationPresent(Query.class)) continue;
            Preconditions.checkArgument(TypeToken.of(Map.class).isSupertypeOf(parameter.getType()), "@Query parameters are expected to be maps. '%s' is not a Map", parameter.getType());
            this.queryParameter = Optional.of(i);
        }
        this.validationPathArguments(method);
    }

    private void validationPathArguments(Invokable<?, ?> method) {
        Sets.SetView<String> difference = Sets.difference(Sets.newHashSet(this.urlTemplate.getPathVariables()), Sets.newHashSet(this.pathArguments.values()));
        Preconditions.checkState(difference.isEmpty(), "The following path arguments found in URL template, but not found in method signature: [%s]. Class: [%s]. Method [%s]. Did you forget @Path annotation?", (Object)Joiner.on(",").join(difference), (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
    }

    private String createUrl(Object ... args) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry<Integer, String> pathVariables : this.pathArguments.entrySet()) {
            parameters.put(pathVariables.getValue(), args[pathVariables.getKey()]);
        }
        UrlTemplate.Merger template = this.urlTemplate.merge().expand(parameters);
        if (this.queryParameter.isPresent()) {
            template.appendQueryParameters((Map)args[this.queryParameter.get()]);
        }
        return template.build();
    }

    @Nullable
    private Object createBody(Object ... args) {
        return this.bodyArgument.isPresent() ? args[this.bodyArgument.get()] : null;
    }

    public <RQ, RS> RestCommand<RQ, RS> createRestCommand(Object ... args) {
        return new RestCommand(this.createUrl(args), this.method, this.createBody(args), this.responseType, this.multiPart);
    }

    private static Type[] getGenericTypeArguments(TypeToken<?> typeToken) {
        Type rawType = typeToken.getType();
        Preconditions.checkArgument(rawType instanceof ParameterizedType, "Incorrect configuration. {} should be parameterized", (Object)rawType);
        return ((ParameterizedType)rawType).getActualTypeArguments();
    }
}

