/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.http;

public enum StatusType {
    INFORMATIONAL(1),
    SUCCESSFUL(2),
    REDIRECTION(3),
    CLIENT_ERROR(4),
    SERVER_ERROR(5);

    private final int value;

    private StatusType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static StatusType valueOf(int status) {
        int seriesCode = status / 100;
        for (StatusType series : StatusType.values()) {
            if (series.value != seriesCode) continue;
            return series;
        }
        throw new IllegalArgumentException("No matching constant for [" + status + "]");
    }
}

