/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.http;

import com.epam.restendpoint.http.DefaultErrorHandler;
import com.epam.restendpoint.http.ErrorHandler;
import com.epam.restendpoint.http.HttpClientRestEndpoint;
import com.epam.restendpoint.http.IOUtils;
import com.epam.restendpoint.http.PreemptiveAuthInterceptor;
import com.epam.restendpoint.http.RestEndpoint;
import com.epam.restendpoint.http.proxy.RestEndpointInvocationHandler;
import com.epam.restendpoint.serializer.ByteArraySerializer;
import com.epam.restendpoint.serializer.Serializer;
import com.epam.restendpoint.serializer.TextSerializer;
import com.epam.restendpoint.serializer.json.GsonSerializer;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import rp.com.google.common.collect.Lists;
import rp.com.google.common.reflect.Reflection;
import rp.org.apache.http.auth.AuthScope;
import rp.org.apache.http.auth.UsernamePasswordCredentials;
import rp.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import rp.org.apache.http.impl.client.BasicCredentialsProvider;
import rp.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import rp.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import rp.org.apache.http.impl.nio.client.HttpAsyncClients;
import rp.org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import rp.org.apache.http.ssl.SSLContexts;

public final class RestEndpoints {
    private RestEndpoints() {
    }

    public static RestEndpoint createDefault() {
        return new HttpClientRestEndpoint(HttpAsyncClients.createDefault(), Lists.newArrayList(new TextSerializer(), new ByteArraySerializer(), new GsonSerializer()), new DefaultErrorHandler());
    }

    public static RestEndpoint createDefault(String endpointUrl) {
        return new HttpClientRestEndpoint(HttpAsyncClients.createDefault(), Lists.newArrayList(new TextSerializer(), new ByteArraySerializer(), new GsonSerializer()), new DefaultErrorHandler(), endpointUrl);
    }

    public static <T> T forInterface(@Nonnull Class<T> clazz, RestEndpoint endpoint) {
        return Reflection.newProxy(clazz, new RestEndpointInvocationHandler(clazz, endpoint));
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private final List<Serializer> serializers = Lists.newArrayList();
        private final HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create();
        private CloseableHttpAsyncClient httpClient;
        private ErrorHandler errorHandler;
        private String endpointUrl;

        Builder() {
        }

        public final RestEndpoint build() {
            CloseableHttpAsyncClient closeableHttpAsyncClient = null == this.httpClient ? this.httpClientBuilder.build() : this.httpClient;
            return new HttpClientRestEndpoint(closeableHttpAsyncClient, this.serializers, this.errorHandler, this.endpointUrl);
        }

        public final Builder withBaseUrl(String url) {
            this.endpointUrl = url;
            return this;
        }

        public final Builder withErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public final Builder withSerializer(Serializer serializer) {
            this.serializers.add(serializer);
            return this;
        }

        public final Builder withHttpClient(CloseableHttpAsyncClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public final Builder withBasicAuth(String username, String password) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
            this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            this.httpClientBuilder.addInterceptorFirst(new PreemptiveAuthInterceptor());
            return this;
        }

        public final Builder withSsl(InputStream keyStore, String keyStorePass) {
            SSLContext sslcontext;
            try {
                sslcontext = SSLContexts.custom().loadTrustMaterial(IOUtils.loadKeyStore(keyStore, keyStorePass), null).build();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load trust store", e);
            }
            SSLIOSessionStrategy sslSessionStrategy = new SSLIOSessionStrategy(sslcontext, new DefaultHostnameVerifier());
            this.httpClientBuilder.setSSLStrategy(sslSessionStrategy);
            return this;
        }

        public final <T> T forInterface(@Nonnull Class<T> clazz) {
            return RestEndpoints.forInterface(clazz, this.build());
        }
    }
}

