/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.http;

import com.epam.restendpoint.http.HttpMethod;
import java.net.URI;
import javax.annotation.concurrent.Immutable;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.collect.ImmutableMultimap;
import rp.com.google.common.collect.Multimap;

@Immutable
public class Response<T> {
    private final URI uri;
    private final HttpMethod httpMethod;
    private final int status;
    private final String reason;
    private final Multimap<String, String> headers;
    private final T body;

    public Response(URI uri, HttpMethod httpMethod, int status, String reason, Multimap<String, String> headers, T body) {
        Preconditions.checkArgument(null != uri, "URL shouldn't be null or empty");
        Preconditions.checkArgument(null != httpMethod, "HttpMethod shouldn't be null or empty");
        Preconditions.checkArgument(status > 0, "Incorrect status code: %s", status);
        Preconditions.checkArgument(null != headers, "Headers shouldn't be null");
        this.uri = uri;
        this.httpMethod = httpMethod;
        this.status = status;
        this.reason = reason;
        this.headers = ImmutableMultimap.copyOf(headers);
        this.body = body;
    }

    public URI getUri() {
        return this.uri;
    }

    public final int getStatus() {
        return this.status;
    }

    public final String getReason() {
        return this.reason;
    }

    public final Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public final T getBody() {
        return this.body;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }
}

