/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import rp.com.google.common.base.Strings;

public final class IOUtils {
    private IOUtils() {
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isValidUrl(String url) {
        try {
            if (Strings.isNullOrEmpty(url)) {
                return false;
            }
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(InputStream keyStore, String password) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(keyStore, password.toCharArray());
            KeyStore keyStore2 = trustStore;
            return keyStore2;
        }
        finally {
            IOUtils.closeQuietly(keyStore);
        }
    }
}

