/*
 * Decompiled with CFR 0.152.
 */
package com.epam.restendpoint.http;

import com.epam.restendpoint.http.ErrorHandler;
import com.epam.restendpoint.http.HttpMethod;
import com.epam.restendpoint.http.Response;
import com.epam.restendpoint.http.StatusType;
import com.epam.restendpoint.http.exception.RestEndpointException;
import com.epam.restendpoint.http.exception.RestEndpointIOException;
import java.net.URI;
import rp.com.google.common.io.ByteSource;

public class DefaultErrorHandler
implements ErrorHandler {
    @Override
    public boolean hasError(Response<ByteSource> rs) {
        StatusType statusType = StatusType.valueOf(rs.getStatus());
        return statusType == StatusType.CLIENT_ERROR || statusType == StatusType.SERVER_ERROR;
    }

    @Override
    public void handle(Response<ByteSource> rs) throws RestEndpointIOException {
        if (!this.hasError(rs)) {
            return;
        }
        this.handleError(rs.getUri(), rs.getHttpMethod(), rs.getStatus(), rs.getReason(), rs.getBody());
    }

    protected void handleError(URI requestUri, HttpMethod requestMethod, int statusCode, String statusMessage, ByteSource errorBody) throws RestEndpointIOException {
        throw new RestEndpointException(requestUri, requestMethod, statusCode, statusMessage, errorBody);
    }
}

