/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.cache.CacheBuilder;
import rp.com.google.common.cache.CacheLoader;
import rp.com.google.common.cache.LoadingCache;
import rp.com.google.common.collect.Lists;

public class ReportPortalImpl
extends ReportPortal {
    private static final Function<EntryCreatedRS, String> TO_ID = new Function<EntryCreatedRS, String>(){

        public String apply(EntryCreatedRS rs) throws Exception {
            return rs.getId();
        }
    };
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private final ReportPortalClient rpClient;
    private final ListenerParameters parameters;
    private final LoadingCache<Maybe<String>, TreeItem> QUEUE = CacheBuilder.newBuilder().build(new CacheLoader<Maybe<String>, TreeItem>(){

        @Override
        public TreeItem load(Maybe<String> key) throws Exception {
            return new TreeItem();
        }
    });
    private Maybe<String> launch;

    ReportPortalImpl(ReportPortalClient rpClient, ListenerParameters parameters) {
        this.rpClient = Preconditions.checkNotNull(rpClient, "RestEndpoint shouldn't be NULL");
        this.parameters = Preconditions.checkNotNull(parameters, "Parameters shouldn't be NULL");
    }

    @Override
    public Maybe<String> startLaunch(StartLaunchRQ rq) {
        this.launch = this.rpClient.startLaunch(rq).doOnSuccess(LoggingCallback.logCreated("launch")).doOnError(LoggingCallback.LOG_ERROR).map(TO_ID).cache();
        this.launch.subscribeOn(Schedulers.io()).subscribe();
        return this.launch;
    }

    @Override
    public void finishLaunch(final FinishExecutionRQ rq) {
        Maybe finish = Completable.concat(this.QUEUE.getUnchecked(this.launch).getChildren()).andThen((MaybeSource)this.launch.flatMap((Function)new Function<String, Maybe<OperationCompletionRS>>(){

            public Maybe<OperationCompletionRS> apply(String id) throws Exception {
                return ReportPortalImpl.this.rpClient.finishLaunch(id, rq).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR);
            }
        })).cache();
        try {
            finish.timeout((long)this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish launch in ReportPortal", (Throwable)e);
        }
    }

    @Override
    public Maybe<String> startTestItem(final StartTestItemRQ rq) {
        Maybe testItem = this.launch.flatMap((Function)new Function<String, Maybe<String>>(){

            public Maybe<String> apply(String id) throws Exception {
                rq.setLaunchId(id);
                return ReportPortalImpl.this.rpClient.startTestItem(rq).doOnSuccess(LoggingCallback.logCreated("item")).doOnError(LoggingCallback.LOG_ERROR).map(TO_ID);
            }
        }).cache();
        testItem.subscribeOn(Schedulers.io()).subscribe();
        this.QUEUE.getUnchecked((Maybe<String>)testItem).addToQueue(testItem.ignoreElement());
        return testItem;
    }

    @Override
    public Maybe<String> startTestItem(final Maybe<String> parentId, final StartTestItemRQ rq) {
        Maybe itemId = this.launch.flatMap((Function)new Function<String, Maybe<String>>(){

            public Maybe<String> apply(final String launchId) throws Exception {
                return parentId.flatMap((Function)new Function<String, MaybeSource<String>>(){

                    public MaybeSource<String> apply(String parentId) throws Exception {
                        rq.setLaunchId(launchId);
                        return ReportPortalImpl.this.rpClient.startTestItem(parentId, rq).doOnSuccess(LoggingCallback.logCreated("item")).doOnError(LoggingCallback.LOG_ERROR).map(TO_ID);
                    }
                });
            }
        }).cache();
        itemId.subscribeOn(Schedulers.io()).subscribe();
        this.QUEUE.getUnchecked((Maybe<String>)itemId).withParent(parentId).addToQueue(itemId.ignoreElement());
        LoggingContext.init((Maybe<String>)itemId, this.rpClient, this.parameters.getBatchLogsSize(), this.parameters.isConvertImage());
        return itemId;
    }

    @Override
    public void finishTestItem(final Maybe<String> itemId, final FinishTestItemRQ rq) {
        Preconditions.checkArgument(null != itemId, "ItemID should not be null");
        this.QUEUE.getUnchecked(this.launch).addToQueue(LoggingContext.complete());
        TreeItem treeItem = (TreeItem)this.QUEUE.getIfPresent(itemId);
        if (null == treeItem) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", itemId);
        }
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)itemId.flatMap((Function)new Function<String, Maybe<OperationCompletionRS>>(){

            public Maybe<OperationCompletionRS> apply(String itemId) throws Exception {
                return ReportPortalImpl.this.rpClient.finishTestItem(itemId, rq).retry((Predicate)new RetryWithDelay((Predicate<? super Throwable>)new Predicate<Throwable>(){

                    public boolean test(Throwable throwable) throws Exception {
                        return throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType());
                    }
                }, 10L, TimeUnit.SECONDS.toMillis(10L))).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR);
            }
        })).doAfterSuccess((Consumer)new Consumer<OperationCompletionRS>(){

            public void accept(OperationCompletionRS operationCompletionRS) throws Exception {
                ReportPortalImpl.this.QUEUE.invalidate(itemId);
            }
        }).ignoreElement().cache();
        finishCompletion.subscribeOn(Schedulers.io()).subscribe();
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            this.QUEUE.getUnchecked(parent).addToQueue(finishCompletion);
        } else {
            this.QUEUE.getUnchecked(this.launch).addToQueue(finishCompletion);
        }
    }

    static class TreeItem {
        private Maybe<String> parent;
        private List<Completable> children = new CopyOnWriteArrayList<Completable>();

        TreeItem() {
        }

        synchronized TreeItem withParent(Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        TreeItem addToQueue(Completable completable) {
            this.children.add(completable);
            return this;
        }

        List<Completable> getChildren() {
            return Lists.newArrayList(this.children);
        }

        synchronized Maybe<String> getParent() {
            return this.parent;
        }
    }
}

