/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.GeneralReportPortalException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.restendpoint.http.DefaultErrorHandler;
import com.epam.restendpoint.http.HttpMethod;
import com.epam.restendpoint.http.exception.RestEndpointIOException;
import com.epam.restendpoint.serializer.Serializer;
import com.epam.ta.reportportal.ws.model.ErrorRS;
import java.io.IOException;
import java.net.URI;
import rp.com.google.common.base.Charsets;
import rp.com.google.common.io.ByteSource;

public class ReportPortalErrorHandler
extends DefaultErrorHandler {
    private Serializer serializer;

    public ReportPortalErrorHandler(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    protected void handleError(URI requestUri, HttpMethod requestMethod, int statusCode, String statusMessage, ByteSource errorBody) throws RestEndpointIOException {
        try {
            byte[] body = errorBody.read();
            ErrorRS errorRS = this.deserializeError(body);
            if (null != errorRS) {
                throw new ReportPortalException(statusCode, statusMessage, errorRS);
            }
            throw new GeneralReportPortalException(statusCode, statusMessage, new String(body, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new GeneralReportPortalException(statusCode, statusMessage, "Cannot read the response");
        }
    }

    private ErrorRS deserializeError(byte[] content) {
        try {
            if (null != content) {
                return this.serializer.deserialize(content, ErrorRS.class);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

