/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.ReportPortalImpl;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Function;
import rp.com.google.common.io.Files;

public abstract class ReportPortal {
    static final Logger LOGGER = LoggerFactory.getLogger(ReportPortal.class);
    public static final ReportPortal NOOP_RP = new ReportPortal(){

        @Override
        public Maybe<String> startLaunch(StartLaunchRQ rq) {
            return Maybe.empty();
        }

        @Override
        public void finishLaunch(FinishExecutionRQ rq) {
        }

        @Override
        public Maybe<String> startTestItem(StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public void finishTestItem(Maybe<String> itemId, FinishTestItemRQ rq) {
        }
    };

    public static ReportPortal startLaunch(ReportPortalClient rpClient, ListenerParameters parameters, StartLaunchRQ rq) {
        if (!parameters.getEnable().booleanValue()) {
            return NOOP_RP;
        }
        ReportPortalImpl service = new ReportPortalImpl(rpClient, parameters);
        service.startLaunch(rq);
        return service;
    }

    public abstract Maybe<String> startLaunch(StartLaunchRQ var1);

    public abstract void finishLaunch(FinishExecutionRQ var1);

    public abstract Maybe<String> startTestItem(StartTestItemRQ var1);

    public abstract Maybe<String> startTestItem(Maybe<String> var1, StartTestItemRQ var2);

    public abstract void finishTestItem(Maybe<String> var1, FinishTestItemRQ var2);

    public static boolean emitLog(Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.CONTEXT_THREAD_LOCAL.get();
        if (null != loggingContext) {
            loggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(final String message, final String level, final Date time) {
        return ReportPortal.emitLog(new Function<String, SaveLogRQ>(){

            @Override
            public SaveLogRQ apply(@Nullable String id) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(id);
                rq.setMessage(message);
                return rq;
            }
        });
    }

    public static boolean emitLog(final String message, final String level, final Date time, final File file) {
        return ReportPortal.emitLog(new Function<String, SaveLogRQ>(){

            @Override
            public SaveLogRQ apply(@Nullable String id) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(id);
                rq.setMessage(message);
                try {
                    SaveLogRQ.File f = new SaveLogRQ.File();
                    f.setContentType(MimeTypeDetector.detect(file));
                    f.setContent(Files.toByteArray(file));
                    f.setName(UUID.randomUUID().toString());
                    rq.setFile(f);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
                }
                return rq;
            }
        });
    }

    public static boolean emitLog(final ReportPortalMessage message, final String level, final Date time) {
        return ReportPortal.emitLog(new Function<String, SaveLogRQ>(){

            @Override
            public SaveLogRQ apply(@Nullable String id) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(level);
                rq.setLogTime(time);
                rq.setTestItemId(id);
                rq.setMessage(message.getMessage());
                try {
                    TypeAwareByteSource data = message.getData();
                    SaveLogRQ.File file = new SaveLogRQ.File();
                    file.setContent(data.read());
                    file.setContentType(data.getMediaType());
                    file.setName(UUID.randomUUID().toString());
                    rq.setFile(file);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
                }
                return rq;
            }
        });
    }
}

