/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.listeners;

import com.epam.reportportal.listeners.ListenersUtils;
import com.epam.reportportal.utils.TagsParser;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.util.Set;

public class ListenerParameters {
    private String description;
    private String uuid;
    private String baseUrl;
    private String projectName;
    private String launchName;
    private Mode launchRunningMode;
    private Set<String> tags;
    private Boolean enable;
    private Boolean isSkippedAnIssue;
    private Integer batchLogsSize;
    private boolean convertImage;
    private Integer reportingTimeout;

    public ListenerParameters() {
    }

    public ListenerParameters(PropertiesLoader properties) {
        this.description = properties.getProperty(ListenerProperty.DESCRIPTION);
        this.uuid = properties.getProperty(ListenerProperty.UUID);
        this.baseUrl = properties.getProperty(ListenerProperty.BASE_URL);
        this.projectName = properties.getProperty(ListenerProperty.PROJECT_NAME);
        this.launchName = properties.getProperty(ListenerProperty.LAUNCH_NAME);
        this.tags = TagsParser.parseAsSet(properties.getProperty(ListenerProperty.LAUNCH_TAGS));
        this.launchRunningMode = ListenersUtils.getLaunchMode(properties.getProperty(ListenerProperty.MODE));
        this.enable = properties.getPropertyAsBoolean(ListenerProperty.ENABLE, true);
        this.isSkippedAnIssue = properties.getPropertyAsBoolean(ListenerProperty.SKIPPED_AS_ISSUE, true);
        this.batchLogsSize = properties.getPropertyAsInt(ListenerProperty.BATCH_SIZE_LOGS, 10);
        this.convertImage = properties.getPropertyAsBoolean(ListenerProperty.IS_CONVERT_IMAGE, false);
        this.reportingTimeout = properties.getPropertyAsInt(ListenerProperty.REPORTING_TIMEOUT, 300);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getLaunchName() {
        return this.launchName;
    }

    public void setLaunchName(String launchName) {
        this.launchName = launchName;
    }

    public Mode getLaunchRunningMode() {
        return this.launchRunningMode;
    }

    public void setLaunchRunningMode(Mode launchRunningMode) {
        this.launchRunningMode = launchRunningMode;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getSkippedAnIssue() {
        return this.isSkippedAnIssue;
    }

    public void setSkippedAnIssue(Boolean skippedAnIssue) {
        this.isSkippedAnIssue = skippedAnIssue;
    }

    public Integer getBatchLogsSize() {
        return this.batchLogsSize;
    }

    public void setBatchLogsSize(Integer batchLogsSize) {
        this.batchLogsSize = batchLogsSize;
    }

    public boolean isConvertImage() {
        return this.convertImage;
    }

    public void setConvertImage(boolean convertImage) {
        this.convertImage = convertImage;
    }

    public Integer getReportingTimeout() {
        return this.reportingTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ListenerParameters{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", baseUrl='").append(this.baseUrl).append('\'');
        sb.append(", projectName='").append(this.projectName).append('\'');
        sb.append(", launchName='").append(this.launchName).append('\'');
        sb.append(", launchRunningMode=").append(this.launchRunningMode);
        sb.append(", tags=").append(this.tags);
        sb.append(", enable=").append(this.enable);
        sb.append(", isSkippedAnIssue=").append(this.isSkippedAnIssue);
        sb.append(", batchLogsSize=").append(this.batchLogsSize);
        sb.append(", convertImage=").append(this.convertImage);
        sb.append('}');
        return sb.toString();
    }
}

