/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.guice;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.guice.ListenerPropertyValue;
import com.epam.reportportal.message.HashMarkSeparatedMessageParser;
import com.epam.reportportal.message.MessageParser;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.ReportPortalErrorHandler;
import com.epam.reportportal.utils.SslUtils;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.restendpoint.http.ErrorHandler;
import com.epam.restendpoint.http.HttpClientRestEndpoint;
import com.epam.restendpoint.http.RestEndpoint;
import com.epam.restendpoint.http.RestEndpoints;
import com.epam.restendpoint.serializer.ByteArraySerializer;
import com.epam.restendpoint.serializer.Serializer;
import com.epam.restendpoint.serializer.json.JacksonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Nullable;
import rp.com.google.common.collect.Lists;
import rp.com.google.inject.Binder;
import rp.com.google.inject.Module;
import rp.com.google.inject.Provides;
import rp.com.google.inject.Singleton;
import rp.com.google.inject.name.Named;
import rp.org.apache.http.HttpException;
import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.HttpRequestInterceptor;
import rp.org.apache.http.client.config.RequestConfig;
import rp.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import rp.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import rp.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import rp.org.apache.http.impl.nio.client.HttpAsyncClients;
import rp.org.apache.http.protocol.HttpContext;
import rp.org.apache.http.ssl.SSLContextBuilder;

public class ReportPortalClientModule
implements Module {
    public static final String API_BASE = "/api/v1";
    private static final String HTTPS = "https";

    @Override
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    public ErrorHandler provideErrorHandler(Serializer serializer) {
        return new ReportPortalErrorHandler(serializer);
    }

    @Provides
    @Singleton
    public Serializer provideSerializer() {
        ObjectMapper om = new ObjectMapper();
        om.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        return new JacksonSerializer(om);
    }

    @Provides
    @Singleton
    @Named(value="serializers")
    public List<Serializer> provideSerializers(Serializer defaultSerializer) {
        return Lists.newArrayList(defaultSerializer, new ByteArraySerializer());
    }

    @Provides
    public RestEndpoint provideRestEndpoint(CloseableHttpAsyncClient httpClient, @Named(value="serializers") List<Serializer> serializers, @ListenerPropertyValue(value=ListenerProperty.BASE_URL) String baseUrl, @ListenerPropertyValue(value=ListenerProperty.PROJECT_NAME) String project, ErrorHandler errorHandler) {
        return new HttpClientRestEndpoint(httpClient, serializers, errorHandler, baseUrl + API_BASE + "/" + project);
    }

    @Provides
    public CloseableHttpAsyncClient provideHttpClient(PropertiesLoader propertiesLoader, @Nullable RequestConfig requestConfig) throws MalformedURLException {
        String baseUrl = propertiesLoader.getProperty(ListenerProperty.BASE_URL);
        String keyStore = propertiesLoader.getProperty(ListenerProperty.KEYSTORE_RESOURCE);
        String keyStorePassword = propertiesLoader.getProperty(ListenerProperty.KEYSTORE_PASSWORD);
        final String uuid = propertiesLoader.getProperty(ListenerProperty.UUID);
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom();
        if (HTTPS.equals(new URL(baseUrl).getProtocol()) && keyStore != null) {
            if (null == keyStorePassword) {
                throw new InternalReportPortalClientException("You should provide keystore password parameter [" + (Object)((Object)ListenerProperty.KEYSTORE_PASSWORD) + "] if you use HTTPS protocol");
            }
            try {
                builder.setSSLContext(SSLContextBuilder.create().loadTrustMaterial(SslUtils.loadKeyStore(keyStore, keyStorePassword), TrustSelfSignedStrategy.INSTANCE).build());
            }
            catch (Exception e) {
                throw new InternalReportPortalClientException("Unable to load trust store");
            }
        }
        return builder.setDefaultRequestConfig(requestConfig == null ? RequestConfig.DEFAULT : requestConfig).addInterceptorLast(new HttpRequestInterceptor(){

            @Override
            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.setHeader("Authorization", "bearer " + uuid);
            }
        }).build();
    }

    @Provides
    @Singleton
    public RequestConfig requestConfig() {
        return RequestConfig.DEFAULT;
    }

    @Provides
    @Singleton
    public ReportPortalClient reportPortalClient(RestEndpoint restEndpoint) {
        return RestEndpoints.forInterface(ReportPortalClient.class, restEndpoint);
    }

    @Provides
    @Singleton
    public MessageParser provideMessageParser() {
        return new HashMarkSeparatedMessageParser();
    }
}

