/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.guice;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.guice.ConfigurationModule;
import com.epam.reportportal.guice.ListenerPropertyValueImpl;
import com.epam.reportportal.guice.ReportPortalClientModule;
import com.epam.reportportal.utils.properties.ListenerProperty;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.base.Splitter;
import rp.com.google.common.base.Strings;
import rp.com.google.common.collect.ImmutableSet;
import rp.com.google.inject.Guice;
import rp.com.google.inject.Key;
import rp.com.google.inject.Module;
import rp.com.google.inject.util.Modules;

public class Injector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Injector.class);
    public static final String RP_EXTENSION_PROPERTY_NAME = "rp.extension";
    private rp.com.google.inject.Injector injector;

    public static Injector createDefault() {
        return Injector.create(Injector.defaultModules());
    }

    public static Injector createDefault(Module ... extensions) {
        return Injector.create(Modules.combine(((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Injector.defaultModules())).add(extensions)).build()));
    }

    public static Injector create(Module ... modules) {
        return new Injector(modules);
    }

    public static Module[] defaultModules() {
        return new Module[]{new ConfigurationModule(), new ReportPortalClientModule()};
    }

    private Injector(Module ... modules) {
        String extensions = System.getProperty(RP_EXTENSION_PROPERTY_NAME, System.getenv(RP_EXTENSION_PROPERTY_NAME));
        if (!Strings.isNullOrEmpty(extensions)) {
            List<Module> extensionModules = this.buildExtensions(extensions);
            this.injector = Guice.createInjector(Modules.override(modules).with(extensionModules));
        } else {
            this.injector = Guice.createInjector(modules);
        }
    }

    public <T> T getBean(Class<T> type) {
        return this.injector.getInstance(type);
    }

    public <T> T getBean(Key<T> key) {
        return this.injector.getInstance(key);
    }

    public String getProperty(ListenerProperty key) {
        return this.injector.getInstance(Key.get(String.class, (Annotation)new ListenerPropertyValueImpl(key)));
    }

    public void injectMembers(Object object) {
        this.injector.injectMembers(object);
    }

    private List<Module> buildExtensions(String extensions) {
        List<String> extensionClasses = Splitter.on(",").splitToList(extensions);
        ArrayList<Module> extensionModules = new ArrayList<Module>(extensionClasses.size());
        for (String extensionClass : extensionClasses) {
            String errorMessage;
            try {
                Class<?> extensionClassObj = Class.forName(extensionClass);
                Preconditions.checkArgument(Module.class.isAssignableFrom(extensionClassObj), "Extension class '%s' is not an Guice's Module", (Object)extensionClass);
                Class<?> extension = extensionClassObj;
                extensionModules.add((Module)extension.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e) {
                errorMessage = "Extension class with name '" + extensionClass + "' not found";
                LOGGER.error(errorMessage);
                throw new InternalReportPortalClientException(errorMessage, e);
            }
            catch (Exception e) {
                errorMessage = "Unable to create instance of '" + extensionClass + "'. Does it have empty constructor?";
                LOGGER.error(errorMessage);
                throw new InternalReportPortalClientException(errorMessage, e);
            }
        }
        return extensionModules;
    }
}

