/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.guice;

import com.epam.reportportal.guice.ListenerPropertyBinder;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import java.lang.annotation.Annotation;
import rp.com.google.inject.Binder;
import rp.com.google.inject.Key;
import rp.com.google.inject.Module;
import rp.com.google.inject.Provider;
import rp.com.google.inject.Provides;
import rp.com.google.inject.Singleton;
import rp.com.google.inject.name.Names;

public class ConfigurationModule
implements Module {
    @Override
    public void configure(Binder binder) {
        final PropertiesLoader properties = PropertiesLoader.load();
        Names.bindProperties(binder, properties.getProperties());
        for (final ListenerProperty listenerProperty : ListenerProperty.values()) {
            binder.bind(Key.get(String.class, (Annotation)ListenerPropertyBinder.named(listenerProperty))).toProvider(new Provider<String>(){

                @Override
                public String get() {
                    return properties.getProperty(listenerProperty.getPropertyName());
                }
            });
        }
        binder.bind(PropertiesLoader.class).toInstance(properties);
    }

    @Provides
    @Singleton
    public ListenerParameters provideListenerProperties(PropertiesLoader propertiesLoader) {
        return new ListenerParameters(propertiesLoader);
    }
}

