/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.testng;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.testng.ITestNGService;
import com.epam.reportportal.testng.TestMethodType;
import com.epam.reportportal.testng.util.ItemTreeUtils;
import com.epam.reportportal.testng.util.internal.LimitedSizeConcurrentHashMap;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.testng.IAttributes;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Factory;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.internal.ConstructorOrMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class TestNGService
implements ITestNGService {
    private static final Set<TestMethodType> BEFORE_METHODS = Stream.of(TestMethodType.BEFORE_TEST, TestMethodType.BEFORE_SUITE, TestMethodType.BEFORE_GROUPS, TestMethodType.BEFORE_CLASS, TestMethodType.BEFORE_METHOD).collect(Collectors.toSet());
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final Set<String> TESTNG_INVOKERS = Stream.of("org.testng.internal.TestInvoker", "org.testng.internal.invokers.TestInvoker").collect(Collectors.toSet());
    private static final Predicate<StackTraceElement> IS_RETRY_ELEMENT = e -> TESTNG_INVOKERS.contains(e.getClassName()) && "retryFailed".equals(e.getMethodName());
    private static final Predicate<StackTraceElement[]> IS_RETRY = eList -> Arrays.stream(eList).anyMatch(IS_RETRY_ELEMENT);
    private static final int MAXIMUM_HISTORY_SIZE = 1000;
    public static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    public static final String RP_ID = "rp_id";
    public static final String RP_RETRY = "rp_retry";
    public static final String RP_METHOD_TYPE = "rp_method_type";
    public static final String NULL_VALUE = "NULL";
    public static final TestItemTree ITEM_TREE = new TestItemTree();
    private final Map<Object, Queue<Pair<Maybe<String>, FinishTestItemRQ>>> BEFORE_METHOD_TRACKER = new ConcurrentHashMap<Object, Queue<Pair<Maybe<String>, FinishTestItemRQ>>>();
    private final Map<Object, Boolean> RETRY_STATUS_TRACKER = new LimitedSizeConcurrentHashMap<Object, Boolean>(1000);
    private final Map<Object, Boolean> SKIPPED_STATUS_TRACKER = new LimitedSizeConcurrentHashMap<Object, Boolean>(1000);
    private final MemoizingSupplier<Launch> launch;
    private volatile Thread shutDownHook;

    private static Thread getShutdownHook(Supplier<Launch> launch) {
        return new Thread(() -> {
            FinishExecutionRQ rq = new FinishExecutionRQ();
            rq.setEndTime(Calendar.getInstance().getTime());
            ((Launch)launch.get()).finish(rq);
        });
    }

    public TestNGService(@Nonnull ReportPortal reportPortal) {
        this.launch = new MemoizingSupplier(() -> {
            StartLaunchRQ startRq = this.buildStartLaunchRq(reportPortal.getParameters());
            startRq.setStartTime(Calendar.getInstance().getTime());
            Launch newLaunch = reportPortal.newLaunch(startRq);
            this.shutDownHook = TestNGService.getShutdownHook(() -> newLaunch);
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
            return newLaunch;
        });
    }

    public TestNGService(Supplier<Launch> launchSupplier) {
        this.launch = new MemoizingSupplier(launchSupplier);
        this.shutDownHook = TestNGService.getShutdownHook(this.launch);
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    @Override
    public void startLaunch() {
        Maybe launchId = ((Launch)this.launch.get()).start();
        ITEM_TREE.setLaunchId(launchId);
    }

    @Override
    public void finishLaunch() {
        FinishExecutionRQ rq = new FinishExecutionRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        ((Launch)this.launch.get()).finish(rq);
        this.launch.reset();
        Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
    }

    private void addToTree(ISuite suite, Maybe<String> item) {
        ITEM_TREE.getTestItems().put(ItemTreeUtils.createKey(suite), TestItemTree.createTestItemLeaf(item));
    }

    @Override
    public void startTestSuite(ISuite suite) {
        StartTestItemRQ rq = this.buildStartSuiteRq(suite);
        Launch myLaunch = (Launch)this.launch.get();
        Maybe item = myLaunch.startTestItem(rq);
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(suite, (Maybe<String>)item);
        }
        suite.setAttribute(RP_ID, (Object)item);
    }

    protected <T> T getAttribute(IAttributes attributes, String attribute) {
        return (T)attributes.getAttribute(attribute);
    }

    @Override
    public void finishTestSuite(ISuite suite) {
        Maybe rpId = (Maybe)this.getAttribute((IAttributes)suite, RP_ID);
        Launch myLaunch = (Launch)this.launch.get();
        if (null != rpId) {
            FinishTestItemRQ rq = this.buildFinishTestSuiteRq(suite);
            myLaunch.finishTestItem(rpId, rq);
            suite.removeAttribute(RP_ID);
        }
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.removeFromTree(suite);
        }
    }

    private void removeFromTree(ISuite suite) {
        ITEM_TREE.getTestItems().remove(ItemTreeUtils.createKey(suite));
    }

    @Override
    public void startTest(ITestContext testContext) {
        if (this.hasMethodsToRun(testContext)) {
            StartTestItemRQ rq = this.buildStartTestItemRq(testContext);
            Launch myLaunch = (Launch)this.launch.get();
            Maybe testID = myLaunch.startTestItem((Maybe)this.getAttribute((IAttributes)testContext.getSuite(), RP_ID), rq);
            if (myLaunch.getParameters().isCallbackReportingEnabled()) {
                this.addToTree(testContext, (Maybe<String>)testID);
            }
            testContext.setAttribute(RP_ID, (Object)testID);
        }
    }

    private void addToTree(ITestContext testContext, Maybe<String> testId) {
        Optional.ofNullable((TestItemTree.TestItemLeaf)ITEM_TREE.getTestItems().get(ItemTreeUtils.createKey(testContext.getSuite()))).ifPresent(suiteLeaf -> {
            List testClasses = testContext.getCurrentXmlTest().getClasses();
            ConcurrentHashMap<TestItemTree.ItemTreeKey, TestItemTree.TestItemLeaf> testClassesMapping = new ConcurrentHashMap<TestItemTree.ItemTreeKey, TestItemTree.TestItemLeaf>(testClasses.size());
            for (XmlClass testClass : testClasses) {
                TestItemTree.TestItemLeaf testClassLeaf = TestItemTree.createTestItemLeaf((Maybe)testId, new ConcurrentHashMap());
                testClassesMapping.put(ItemTreeUtils.createKey(testClass), testClassLeaf);
            }
            suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(testContext), TestItemTree.createTestItemLeaf((Maybe)testId, testClassesMapping));
        });
    }

    private static Set<ITestResult> getTestResults(IResultMap rm) {
        return Optional.ofNullable(rm).map(IResultMap::getAllResults).orElse(Collections.emptySet());
    }

    @Override
    public void finishTest(ITestContext testContext) {
        if (this.hasMethodsToRun(testContext)) {
            FinishTestItemRQ rq = this.buildFinishTestRq(testContext);
            ((Launch)this.launch.get()).finishTestItem((Maybe)this.getAttribute((IAttributes)testContext, RP_ID), rq);
            if (((Launch)this.launch.get()).getParameters().isCallbackReportingEnabled()) {
                this.removeFromTree(testContext);
            }
            HashSet<ITestResult> results = new HashSet<ITestResult>();
            results.addAll(TestNGService.getTestResults(testContext.getFailedButWithinSuccessPercentageTests()));
            results.addAll(TestNGService.getTestResults(testContext.getFailedConfigurations()));
            results.addAll(TestNGService.getTestResults(testContext.getFailedTests()));
            results.addAll(TestNGService.getTestResults(testContext.getSkippedTests()));
            results.addAll(TestNGService.getTestResults(testContext.getSkippedConfigurations()));
            results.addAll(TestNGService.getTestResults(testContext.getPassedConfigurations()));
            results.addAll(TestNGService.getTestResults(testContext.getPassedTests()));
            results.stream().map(ITestResult::getInstance).filter(Objects::nonNull).collect(Collectors.toSet()).forEach(i -> {
                this.RETRY_STATUS_TRACKER.remove(i);
                this.SKIPPED_STATUS_TRACKER.remove(i);
            });
        }
    }

    private void removeFromTree(ITestContext testContext) {
        Optional.ofNullable((TestItemTree.TestItemLeaf)ITEM_TREE.getTestItems().get(ItemTreeUtils.createKey(testContext.getSuite()))).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(testContext)));
    }

    private boolean isRetry(ITestResult testResult) {
        if (testResult.wasRetried()) {
            return true;
        }
        Object instance = testResult.getInstance();
        if (instance != null && this.RETRY_STATUS_TRACKER.containsKey(instance)) {
            return true;
        }
        return IS_RETRY.test(Thread.currentThread().getStackTrace());
    }

    @Nonnull
    protected StartTestItemRQ buildStartConfigurationRq(@Nonnull ITestResult testResult, @Nullable TestMethodType type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.createConfigurationName(testResult));
        rq.setCodeRef(testResult.getMethod().getQualifiedName());
        rq.setDescription(this.createConfigurationDescription(testResult));
        rq.setStartTime(new Date(testResult.getStartMillis()));
        rq.setType(type == null ? null : type.toString());
        boolean retry = this.isRetry(testResult);
        if (retry) {
            rq.setRetry(Boolean.TRUE);
        }
        return rq;
    }

    @Override
    public void startConfiguration(ITestResult testResult) {
        if (Optional.ofNullable(this.getAttribute((IAttributes)testResult, RP_ID)).isPresent()) {
            return;
        }
        TestMethodType type = TestMethodType.getStepType(testResult.getMethod());
        testResult.setAttribute(RP_METHOD_TYPE, (Object)type);
        StartTestItemRQ rq = this.buildStartConfigurationRq(testResult, type);
        if (Boolean.TRUE == rq.isRetry()) {
            testResult.setAttribute(RP_RETRY, (Object)Boolean.TRUE);
        }
        Maybe<String> parentId = this.getConfigParent(testResult, type);
        Launch myLaunch = (Launch)this.launch.get();
        Maybe itemID = myLaunch.startTestItem(parentId, rq);
        testResult.setAttribute(RP_ID, (Object)itemID);
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull ITestResult testResult, @Nonnull TestMethodType type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.createStepName(testResult));
        String codeRef = testResult.getMethod().getQualifiedName();
        rq.setCodeRef(codeRef);
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, testResult)).map(TestCaseIdEntry::getId).orElse(null));
        rq.setAttributes(this.createStepAttributes(testResult));
        rq.setDescription(this.createStepDescription(testResult));
        rq.setParameters(this.createStepParameters(testResult));
        rq.setStartTime(new Date(testResult.getStartMillis()));
        rq.setType(type.toString());
        boolean retry = this.isRetry(testResult);
        if (retry) {
            rq.setRetry(Boolean.TRUE);
        }
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull ITestResult testResult) {
        TestMethodType methodType = Optional.ofNullable(TestMethodType.getStepType(testResult.getMethod())).orElse(TestMethodType.STEP);
        testResult.setAttribute(RP_METHOD_TYPE, (Object)methodType);
        return this.buildStartStepRq(testResult, methodType);
    }

    private void addToTree(ITestResult testResult, Maybe<String> stepMaybe) {
        ITestContext testContext = testResult.getTestContext();
        Optional.ofNullable((TestItemTree.TestItemLeaf)ITEM_TREE.getTestItems().get(ItemTreeUtils.createKey(testContext.getSuite()))).flatMap(suiteLeaf -> Optional.ofNullable((TestItemTree.TestItemLeaf)suiteLeaf.getChildItems().get(ItemTreeUtils.createKey(testContext))).flatMap(testLeaf -> Optional.ofNullable((TestItemTree.TestItemLeaf)testLeaf.getChildItems().get(ItemTreeUtils.createKey(testResult.getTestClass()))))).ifPresent(testClassLeaf -> testClassLeaf.getChildItems().put(ItemTreeUtils.createKey(testResult), TestItemTree.createTestItemLeaf((Maybe)stepMaybe)));
    }

    @Override
    public void startTestMethod(@Nonnull ITestResult testResult) {
        StartTestItemRQ rq = this.buildStartStepRq(testResult);
        if (Boolean.TRUE == rq.isRetry()) {
            testResult.setAttribute(RP_RETRY, (Object)Boolean.TRUE);
        }
        Launch myLaunch = (Launch)this.launch.get();
        Maybe stepMaybe = myLaunch.startTestItem((Maybe)this.getAttribute((IAttributes)testResult.getTestContext(), RP_ID), rq);
        testResult.setAttribute(RP_ID, (Object)stepMaybe);
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(testResult, (Maybe<String>)stepMaybe);
        }
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestMethodRq(@Nonnull ItemStatus status, @Nonnull ITestResult testResult) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(new Date(testResult.getEndMillis()));
        rq.setStatus(status.name());
        return rq;
    }

    @Deprecated
    @Nonnull
    protected FinishTestItemRQ buildFinishTestMethodRq(@Nonnull String status, @Nonnull ITestResult testResult) {
        return this.buildFinishTestMethodRq(ItemStatus.valueOf((String)status), testResult);
    }

    private void updateTestItemTree(Maybe<OperationCompletionRS> finishItemResponse, ITestResult testResult) {
        TestItemTree.TestItemLeaf testItemLeaf;
        TestItemTree.TestItemLeaf testClassLeaf;
        TestItemTree.TestItemLeaf testLeaf;
        ITestContext testContext = testResult.getTestContext();
        TestItemTree.TestItemLeaf suiteLeaf = (TestItemTree.TestItemLeaf)ITEM_TREE.getTestItems().get(ItemTreeUtils.createKey(testContext.getSuite()));
        if (suiteLeaf != null && (testLeaf = (TestItemTree.TestItemLeaf)suiteLeaf.getChildItems().get(ItemTreeUtils.createKey(testContext))) != null && (testClassLeaf = (TestItemTree.TestItemLeaf)testLeaf.getChildItems().get(ItemTreeUtils.createKey(testResult.getTestClass()))) != null && (testItemLeaf = (TestItemTree.TestItemLeaf)testClassLeaf.getChildItems().get(ItemTreeUtils.createKey(testResult))) != null) {
            testItemLeaf.setFinishResponse(finishItemResponse);
        }
    }

    private void processFinishRetryFlag(ITestResult testResult, FinishTestItemRQ rq) {
        Object instance = testResult.getInstance();
        if (instance != null && !ItemStatus.SKIPPED.name().equals(rq.getStatus())) {
            this.RETRY_STATUS_TRACKER.remove(instance);
        }
        TestMethodType type = (TestMethodType)((Object)this.getAttribute((IAttributes)testResult, RP_METHOD_TYPE));
        boolean isRetried = testResult.wasRetried();
        if (TestMethodType.STEP == type && this.getAttribute((IAttributes)testResult, RP_RETRY) == null && isRetried) {
            this.RETRY_STATUS_TRACKER.put(instance, Boolean.TRUE);
            rq.setRetry(Boolean.TRUE);
            rq.setIssue(Launch.NOT_ISSUE);
        }
        if (isRetried) {
            testResult.setAttribute(RP_RETRY, (Object)Boolean.TRUE);
        }
        if (instance != null) {
            if (TestMethodType.BEFORE_METHOD == type && this.getAttribute((IAttributes)testResult, RP_RETRY) == null) {
                Maybe itemId = (Maybe)this.getAttribute((IAttributes)testResult, RP_ID);
                this.BEFORE_METHOD_TRACKER.computeIfAbsent(instance, i -> new ConcurrentLinkedQueue()).add(Pair.of((Object)itemId, (Object)rq));
            } else {
                Queue<Pair<Maybe<String>, FinishTestItemRQ>> beforeFinish = this.BEFORE_METHOD_TRACKER.remove(instance);
                if (beforeFinish != null && isRetried) {
                    beforeFinish.stream().filter(e -> ((FinishTestItemRQ)e.getValue()).isRetry() == null || ((FinishTestItemRQ)e.getValue()).isRetry() == false).forEach(e -> {
                        FinishTestItemRQ f = (FinishTestItemRQ)e.getValue();
                        f.setRetry(Boolean.valueOf(true));
                        ((Launch)this.launch.get()).finishTestItem((Maybe)e.getKey(), f);
                    });
                }
            }
        }
    }

    protected void createSkippedSteps(ITestResult testResult) {
    }

    @Override
    public void finishTestMethod(ItemStatus status, ITestResult testResult) {
        Maybe itemId = (Maybe)this.getAttribute((IAttributes)testResult, RP_ID);
        if (ItemStatus.SKIPPED == status) {
            if (!testResult.wasRetried() && null == itemId) {
                this.startTestMethod(testResult);
                itemId = (Maybe)this.getAttribute((IAttributes)testResult, RP_ID);
            }
            this.createSkippedSteps(testResult);
        }
        FinishTestItemRQ rq = this.buildFinishTestMethodRq(status, testResult);
        TestMethodType type = (TestMethodType)((Object)this.getAttribute((IAttributes)testResult, RP_METHOD_TYPE));
        Object instance = testResult.getInstance();
        if (instance != null) {
            if (ItemStatus.FAILED == status && (TestMethodType.BEFORE_METHOD == type || TestMethodType.BEFORE_CLASS == type)) {
                this.SKIPPED_STATUS_TRACKER.put(instance, Boolean.TRUE);
            }
            if (ItemStatus.SKIPPED == status && (this.SKIPPED_STATUS_TRACKER.containsKey(instance) || TestMethodType.BEFORE_METHOD == type && this.getAttribute((IAttributes)testResult, RP_RETRY) != null)) {
                rq.setIssue(Launch.NOT_ISSUE);
            }
            if (ItemStatus.SKIPPED == status && BEFORE_METHODS.contains((Object)type) && testResult.getThrowable() != null) {
                this.sendReportPortalMsg(testResult);
                this.SKIPPED_STATUS_TRACKER.put(instance, Boolean.TRUE);
            }
        }
        this.processFinishRetryFlag(testResult, rq);
        Maybe finishItemResponse = ((Launch)this.launch.get()).finishTestItem(itemId, rq);
        if (((Launch)this.launch.get()).getParameters().isCallbackReportingEnabled()) {
            this.updateTestItemTree((Maybe<OperationCompletionRS>)finishItemResponse, testResult);
        }
    }

    @Override
    @Deprecated
    public void finishTestMethod(String statusStr, ITestResult testResult) {
        ItemStatus status = ItemStatus.valueOf((String)statusStr);
        this.finishTestMethod(status, testResult);
    }

    @Override
    public void sendReportPortalMsg(ITestResult result) {
        ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            rq.setLevel("ERROR");
            if (result.getThrowable() != null) {
                rq.setMessage(ExceptionUtils.getStackTrace((Throwable)result.getThrowable()));
            } else {
                rq.setMessage("Test has failed without exception");
            }
            rq.setLogTime(Calendar.getInstance().getTime());
            return rq;
        });
    }

    protected StartTestItemRQ buildStartSuiteRq(ISuite suite) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(suite.getName());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("SUITE");
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartTestItemRq(@Nonnull ITestContext testContext) {
        StartTestItemRQ rq = new StartTestItemRQ();
        HashSet attributes = rq.getAttributes() == null ? new HashSet() : new HashSet(rq.getAttributes());
        rq.setAttributes(attributes);
        Optional.ofNullable(testContext.getCurrentXmlTest()).map(XmlTest::getXmlClasses).ifPresent(xmlClasses -> xmlClasses.forEach(xmlClass -> {
            String className = xmlClass.getName();
            String codeRef = rq.getCodeRef();
            rq.setCodeRef((String)(codeRef == null ? className : codeRef + ";" + className));
            Optional.ofNullable(xmlClass.getSupportClass()).map(c -> c.getAnnotation(Attributes.class)).ifPresent(a -> attributes.addAll(AttributeParser.retrieveAttributes((Attributes)a)));
        }));
        rq.setName(testContext.getName());
        rq.setStartTime(testContext.getStartDate());
        rq.setType("TEST");
        return rq;
    }

    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime(Calendar.getInstance().getTime());
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>(parameters.getAttributes());
        rq.setAttributes(attributes);
        rq.setMode(parameters.getLaunchRunningMode());
        rq.setRerun(parameters.isRerun());
        if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
            rq.setRerunOf(parameters.getRerunOf());
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.getDescription())) {
            rq.setDescription(parameters.getDescription());
        }
        if (null != parameters.getSkippedAnIssue()) {
            ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
            skippedIssueAttribute.setKey(SKIPPED_ISSUE_KEY);
            skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
            skippedIssueAttribute.setSystem(true);
            attributes.add(skippedIssueAttribute);
        }
        attributes.addAll(SystemAttributesExtractor.extract((String)AGENT_PROPERTIES_FILE, (ClassLoader)TestNGService.class.getClassLoader()));
        return rq;
    }

    protected FinishTestItemRQ buildFinishTestSuiteRq(ISuite suite) {
        Date now = Calendar.getInstance().getTime();
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(now);
        return rq;
    }

    protected FinishTestItemRQ buildFinishTestRq(ITestContext testContext) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(testContext.getEndDate());
        return rq;
    }

    protected List<ParameterResource> createStepParameters(ITestResult testResult) {
        List parameters = Lists.newArrayList();
        parameters.addAll(this.createDataProviderParameters(testResult));
        parameters.addAll(this.createAnnotationParameters(testResult));
        parameters.addAll(this.crateFactoryParameters(testResult));
        return parameters.isEmpty() ? null : parameters;
    }

    @Nonnull
    private List<ParameterResource> createAnnotationParameters(@Nonnull ITestResult testResult) {
        return this.getMethodAnnotation(Parameters.class, testResult).map(a -> {
            String[] keys = a.value();
            Object[] parameters = testResult.getParameters();
            if (parameters.length != keys.length || keys.length <= 0) {
                return Collections.emptyList();
            }
            return IntStream.range(0, keys.length).mapToObj(i -> {
                ParameterResource parameter = new ParameterResource();
                parameter.setKey(keys[i]);
                parameter.setValue(parameters[i] == null ? NULL_VALUE : parameters[i].toString());
                return parameter;
            }).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    @Nonnull
    private List<ParameterResource> createDataProviderParameters(@Nonnull ITestResult testResult) {
        return this.getMethodAnnotation(Test.class, testResult).map(a -> {
            Method method = this.getMethod(testResult);
            Object[] parameters = testResult.getParameters();
            if (method == null || StringUtils.isBlank((CharSequence)a.dataProvider()) || parameters == null || parameters.length <= 0) {
                return Collections.emptyList();
            }
            return ParameterUtils.getParameters((Executable)method, Arrays.asList(parameters));
        }).orElse(Collections.emptyList());
    }

    private List<ParameterResource> crateFactoryParameters(ITestResult testResult) {
        Object[] parameters = testResult.getFactoryParameters();
        Constructor[] constructors = Optional.ofNullable(this.getMethod(testResult)).map(Method::getDeclaringClass).map(Class::getConstructors).orElse(new Constructor[0]);
        Constructor constructor = Arrays.stream(constructors).filter(c -> {
            Factory factoryAnnotation = c.getAnnotation(Factory.class);
            if (factoryAnnotation == null) {
                return false;
            }
            if (c.getParameterCount() != parameters.length) {
                return false;
            }
            Class[] types = c.getParameterTypes();
            return IntStream.range(0, types.length).mapToObj(i -> {
                Class type = types[i];
                Class boxedClass = ParameterUtils.toBoxedType((Class)type);
                return Optional.ofNullable(parameters[i]).map(p -> boxedClass == p.getClass()).orElse(true);
            }).allMatch(b -> b == Boolean.TRUE);
        }).findAny().orElse(null);
        if (parameters == null || parameters.length <= 0 || constructor == null) {
            return Collections.emptyList();
        }
        return ParameterUtils.getParameters((Executable)constructor, Arrays.asList(parameters));
    }

    protected String createConfigurationName(ITestResult testResult) {
        return testResult.getMethod().getMethodName();
    }

    protected String createConfigurationDescription(ITestResult testResult) {
        return testResult.getMethod().getDescription();
    }

    protected String createStepName(ITestResult testResult) {
        return testResult.getMethod().getMethodName();
    }

    protected String createStepDescription(ITestResult testResult) {
        return testResult.getMethod().getDescription();
    }

    @Nullable
    private TestCaseIdEntry getTestCaseId(@Nonnull String codeRef, @Nonnull ITestResult testResult) {
        Method method = this.getMethod(testResult);
        Object instance = testResult.getInstance();
        List parameters = Optional.ofNullable(testResult.getParameters()).map(Arrays::asList).orElse(null);
        TestCaseIdEntry id = this.getMethodAnnotation(TestCaseId.class, testResult).flatMap(a -> Optional.ofNullable(method).map(m -> TestCaseIdUtils.getTestCaseId((TestCaseId)a, (Executable)m, (String)codeRef, (List)parameters, (Object)instance))).orElse(TestCaseIdUtils.getTestCaseId((String)codeRef, (List)parameters));
        return id == null ? null : (id.getId().endsWith("[]") ? new TestCaseIdEntry(id.getId().substring(0, id.getId().length() - 2)) : id);
    }

    @Nullable
    protected Set<ItemAttributesRQ> createStepAttributes(@Nonnull ITestResult testResult) {
        return this.getMethodAnnotation(Attributes.class, testResult).map(AttributeParser::retrieveAttributes).orElse(null);
    }

    @Nullable
    private Method getMethod(@Nonnull ITestResult testResult) {
        return Optional.ofNullable(testResult.getMethod()).map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod).orElse(null);
    }

    @Nonnull
    private <T extends Annotation> Optional<T> getMethodAnnotation(@Nonnull Class<T> annotation, @Nonnull ITestResult testResult) {
        return Optional.ofNullable(this.getMethod(testResult)).map(m -> m.getAnnotation(annotation));
    }

    private boolean hasMethodsToRun(ITestContext testContext) {
        return null != testContext && null != testContext.getAllTestMethods() && 0 != testContext.getAllTestMethods().length;
    }

    Maybe<String> getConfigParent(ITestResult testResult, TestMethodType type) {
        Maybe parentId = TestMethodType.BEFORE_SUITE.equals((Object)type) || TestMethodType.AFTER_SUITE.equals((Object)type) ? (Maybe)this.getAttribute((IAttributes)testResult.getTestContext().getSuite(), RP_ID) : (Maybe)this.getAttribute((IAttributes)testResult.getTestContext(), RP_ID);
        return parentId;
    }
}

