/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber.util;

import com.epam.reportportal.service.tree.TestItemTree;
import java.util.Optional;

public class ItemTreeUtils {
    private ItemTreeUtils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static TestItemTree.ItemTreeKey createKey(String key) {
        return TestItemTree.ItemTreeKey.of((String)key);
    }

    public static TestItemTree.ItemTreeKey createKey(int lineNumber) {
        return TestItemTree.ItemTreeKey.of((String)String.valueOf(lineNumber));
    }

    public static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(String featureUri, TestItemTree testItemTree) {
        return Optional.ofNullable(testItemTree.getTestItems().get(ItemTreeUtils.createKey(featureUri)));
    }

    public static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(String featureUri, int lineNumber, TestItemTree testItemTree) {
        Optional<TestItemTree.TestItemLeaf> suiteLeaf = ItemTreeUtils.retrieveLeaf(featureUri, testItemTree);
        return suiteLeaf.map(leaf -> (TestItemTree.TestItemLeaf)leaf.getChildItems().get(ItemTreeUtils.createKey(lineNumber)));
    }

    public static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(String featureUri, int lineNumber, String text, TestItemTree testItemTree) {
        Optional<TestItemTree.TestItemLeaf> testClassLeaf = ItemTreeUtils.retrieveLeaf(featureUri, lineNumber, testItemTree);
        return testClassLeaf.map(leaf -> (TestItemTree.TestItemLeaf)leaf.getChildItems().get(ItemTreeUtils.createKey(text)));
    }
}

