/*
 * Decompiled with CFR 0.152.
 */
package com.epam.cucmber.stepdefs;

import com.epam.cucmber.stepdefs.FormActions;
import com.epam.jdi.uitests.core.interfaces.base.IComposite;
import com.epam.jdi.uitests.core.interfaces.base.IElement;
import com.epam.jdi.uitests.core.interfaces.complex.IForm;
import com.epam.jdi.uitests.web.selenium.elements.composite.WebPage;
import com.epam.jdi.uitests.web.selenium.elements.composite.WebSite;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Utils {
    private Utils() {
    }

    public static Object getClassField(Class container, String fieldName) {
        Object result;
        try {
            result = container.getDeclaredField(fieldName).get(new Object());
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static Object getClassField(Object container, String fieldName) {
        Object result;
        try {
            Field f = container.getClass().getDeclaredField(fieldName);
            Object parent = Modifier.isStatic(f.getModifiers()) ? new Object() : container;
            result = f.get(parent);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static Object getClassField(String containerName) {
        Class i;
        Class[] containers = new Class[]{WebPage.currentPage.getClass(), WebSite.currentSite};
        Object resultElement = null;
        Class[] classArray = containers;
        int n = classArray.length;
        for (int j = 0; j < n && (resultElement = Utils.getClassField(i = classArray[j], containerName)) == null; ++j) {
        }
        return resultElement;
    }

    public static Object getClassField(String containerName, ArrayList<Object> containers, Class expectedClass) {
        Object resultElement = null;
        for (Object i : containers) {
            resultElement = Utils.getClassField(i, containerName);
            if (resultElement == null) continue;
            if (!expectedClass.isInstance(resultElement)) {
                resultElement = null;
            }
            if (resultElement == null) continue;
            break;
        }
        return resultElement;
    }

    public static Type getParameterizedTypeForm(Object form) {
        Class<?> clazz = form.getClass();
        ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
        return parameterizedType.getActualTypeArguments()[0];
    }

    public static Object createFromGSON(String json, Type t) {
        return new Gson().fromJson(json, t);
    }

    public static Object createFromJSON(String json, Type t) throws Exception {
        Object result = ((Class)t).newInstance();
        Map mJson = (Map)new Gson().fromJson(json, Map.class);
        for (Map.Entry e : mJson.entrySet()) {
            Field f = result.getClass().getDeclaredField((String)e.getKey());
            f.setAccessible(true);
            f.set(result, e.getValue());
        }
        return result;
    }

    public static void processForm(String formName, String json, FormActions action) throws Exception {
        IForm form = (IForm)Utils.getClassField(WebPage.currentPage, formName);
        Object entity = Utils.createFromJSON(json, Utils.getParameterizedTypeForm(form));
        switch (action) {
            case SUBMIT: {
                form.submit(entity);
                break;
            }
            case FILL: {
                form.fill(entity);
                break;
            }
            case CHECK: {
                form.check(entity);
            }
        }
    }

    public static List<Object> filterCompositeFields(Object o) throws IllegalAccessException {
        ArrayList<Object> containers = new ArrayList<Object>();
        for (Field f : o instanceof Class ? ((Class)o).getFields() : o.getClass().getFields()) {
            Object fData = f.get(o);
            if (!(fData instanceof IComposite) || f.getName().equals("currentPage")) continue;
            containers.add(fData);
            containers.addAll(Utils.filterCompositeFields(fData));
        }
        return containers;
    }

    public static Object getClassFieldAnyway(String fieldName, Class expectedClass) throws IllegalAccessException {
        return Utils.getClassField(fieldName, new ArrayList<Object>(Utils.filterCompositeFields(WebSite.currentSite)), expectedClass);
    }

    public static Object getClassFieldAnyway(String fieldName) throws IllegalAccessException {
        return Utils.getClassField(fieldName, new ArrayList<Object>(Utils.filterCompositeFields(WebSite.currentSite)), IElement.class);
    }
}

