/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.treecomparing;

import com.epam.healenium.treecomparing.DocumentParser;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

public class JsoupHTMLParser
implements DocumentParser {
    @Override
    public Node parse(InputStream inputStream) {
        try {
            Document document = Jsoup.parse((InputStream)inputStream, (String)"UTF-8", (String)"/");
            org.jsoup.nodes.Node html = this.findHtml(Collections.singletonList(document.root()));
            int startIndex = 0;
            ArrayDeque<NodeBuilder> treeDepth = new ArrayDeque<NodeBuilder>();
            return this.traverse(html, startIndex, treeDepth);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Node traverse(org.jsoup.nodes.Node node, Integer index, Deque<NodeBuilder> treeDepth) {
        Map<String, String> attributesMap = node.attributes().asList().stream().collect(Collectors.toMap(Attribute::getKey, Attribute::getValue));
        NodeBuilder builder = new NodeBuilder().setTag(node.nodeName()).setIndex(index).setAttributes(attributesMap);
        treeDepth.push(builder);
        int indexCounter = 0;
        for (org.jsoup.nodes.Node child : node.childNodes()) {
            if (child instanceof Element) {
                builder.addChild(this.traverse(child, indexCounter++, treeDepth));
                continue;
            }
            if (!(child instanceof TextNode)) continue;
            String text = ((TextNode)child).text();
            for (NodeBuilder parentBuilder : treeDepth) {
                parentBuilder.addContent(text);
            }
        }
        treeDepth.pop();
        return builder.build();
    }

    private org.jsoup.nodes.Node findHtml(List<org.jsoup.nodes.Node> nodes) {
        for (org.jsoup.nodes.Node node : nodes) {
            if (!node.nodeName().equals("html")) continue;
            return node;
        }
        LinkedList<org.jsoup.nodes.Node> newNodes = new LinkedList<org.jsoup.nodes.Node>();
        for (org.jsoup.nodes.Node node : nodes) {
            newNodes.addAll(node.childNodes());
        }
        return this.findHtml(newNodes);
    }
}

