/*
 * Decompiled with CFR 0.152.
 */
package uk.ydubey.formatter.numtoword;

import java.util.ArrayList;
import uk.ydubey.formatter.numtoword.TwoDigitNumberInWordsFormatter;

public class ThreeDigitNumberInWordsFormatter
extends TwoDigitNumberInWordsFormatter {
    private static final ThreeDigitNumberInWordsFormatter INSTANCE = new ThreeDigitNumberInWordsFormatter();

    protected ThreeDigitNumberInWordsFormatter() {
    }

    public static ThreeDigitNumberInWordsFormatter getInstance() {
        return INSTANCE;
    }

    @Override
    public int getLimit() {
        return 999;
    }

    @Override
    protected String parseAndFormat(int number) {
        if (number <= super.getLimit()) {
            return super.parseAndFormat(number);
        }
        ArrayList<String> numberInWordsParts = new ArrayList<String>();
        int hundreds = number / 100;
        numberInWordsParts.add(super.parseAndFormat(hundreds));
        numberInWordsParts.add("hundred");
        String tensAndUnitsInWords = super.parseAndFormat(number % 100);
        if (tensAndUnitsInWords.length() > 0) {
            numberInWordsParts.add("and");
            numberInWordsParts.add(tensAndUnitsInWords);
        }
        return ThreeDigitNumberInWordsFormatter.join(numberInWordsParts);
    }
}

