/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.IMetricValue;
import com.dynatrace.metric.util.MetricException;

final class MetricValues {
    MetricValues() {
    }

    private static void throwIfNaNOrInfDouble(double d) throws MetricException {
        if (Double.isNaN(d)) {
            throw new MetricException("Value was NaN.");
        }
        if (Double.isInfinite(d)) {
            throw new MetricException(String.format("Value was infinite (%f).", d));
        }
    }

    static String formatDouble(double d) {
        return String.valueOf(d);
    }

    static final class DoubleGaugeValue
    implements IMetricValue {
        private final double value;

        DoubleGaugeValue(double value) throws MetricException {
            MetricValues.throwIfNaNOrInfDouble(value);
            this.value = value;
        }

        @Override
        public String serialize() {
            return String.format("gauge,%s", MetricValues.formatDouble(this.value));
        }
    }

    static final class DoubleSummaryValue
    implements IMetricValue {
        private final double min;
        private final double max;
        private final double sum;
        private final long count;

        DoubleSummaryValue(double min, double max, double sum, long count) throws MetricException {
            MetricValues.throwIfNaNOrInfDouble(min);
            MetricValues.throwIfNaNOrInfDouble(max);
            MetricValues.throwIfNaNOrInfDouble(sum);
            if (count < 0L) {
                throw new MetricException("count cannot be negative");
            }
            if (min > max) {
                throw new MetricException("min cannot be greater than max!");
            }
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.count = count;
        }

        @Override
        public String serialize() {
            return String.format("gauge,min=%s,max=%s,sum=%s,count=%d", MetricValues.formatDouble(this.min), MetricValues.formatDouble(this.max), MetricValues.formatDouble(this.sum), this.count);
        }
    }

    static final class DoubleCounterValue
    implements IMetricValue {
        private final double value;
        private final boolean absolute;

        DoubleCounterValue(double value, boolean isDelta) throws MetricException {
            MetricValues.throwIfNaNOrInfDouble(value);
            this.value = value;
            this.absolute = isDelta;
        }

        @Override
        public String serialize() {
            if (this.absolute) {
                return String.format("count,delta=%s", MetricValues.formatDouble(this.value));
            }
            return String.format("count,%s", MetricValues.formatDouble(this.value));
        }
    }

    static final class LongGaugeValue
    implements IMetricValue {
        private final long value;

        LongGaugeValue(long value) {
            this.value = value;
        }

        @Override
        public String serialize() {
            return String.format("gauge,%d", this.value);
        }
    }

    static final class LongSummaryValue
    implements IMetricValue {
        private final long min;
        private final long max;
        private final long sum;
        private final long count;

        LongSummaryValue(long min, long max, long sum, long count) throws MetricException {
            if (count < 0L) {
                throw new MetricException("count cannot be negative");
            }
            if (min > max) {
                throw new MetricException("min cannot be greater than max!");
            }
            this.min = min;
            this.max = max;
            this.sum = sum;
            this.count = count;
        }

        @Override
        public String serialize() {
            return String.format("gauge,min=%d,max=%d,sum=%d,count=%d", this.min, this.max, this.sum, this.count);
        }
    }

    static final class LongCounterValue
    implements IMetricValue {
        private final long value;
        private final boolean isDelta;

        LongCounterValue(long value, boolean isDelta) {
            this.value = value;
            this.isDelta = isDelta;
        }

        @Override
        public String serialize() {
            if (this.isDelta) {
                return String.format("count,delta=%d", this.value);
            }
            return String.format("count,%d", this.value);
        }
    }
}

