/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.model;

import com.dynatrace.android.sessionreplay.model.Checkpoint;
import com.dynatrace.android.sessionreplay.model.Durable;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.EventType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/dynatrace/android/sessionreplay/model/GestureEvent;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Lcom/dynatrace/android/sessionreplay/model/Durable;", "id", "", "startTime", "Ljava/util/Date;", "<init>", "(Ljava/lang/String;Ljava/util/Date;)V", "type", "Lcom/dynatrace/android/sessionreplay/model/EventType;", "getType", "()Lcom/dynatrace/android/sessionreplay/model/EventType;", "_checkpoints", "", "Lcom/dynatrace/android/sessionreplay/model/Checkpoint;", "checkpoints", "", "getCheckpoints", "()Ljava/util/List;", "addCheckpoint", "", "checkpoint", "removeCheckpoint", "getEndTime", "model_release"})
public final class GestureEvent
extends Event
implements Durable {
    @NotNull
    private final EventType type;
    @NotNull
    private final List<Checkpoint> _checkpoints;
    @NotNull
    private final List<Checkpoint> checkpoints;

    public GestureEvent(@NotNull String id, @NotNull Date startTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        super(id, startTime, null, 0L, null, 16, null);
        this.type = EventType.GESTURE;
        this._checkpoints = new ArrayList();
        this.checkpoints = this._checkpoints;
    }

    public /* synthetic */ GestureEvent(String string, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = UUID.randomUUID().toString();
        }
        if ((n & 2) != 0) {
            date = new Date();
        }
        this(string, date);
    }

    @Override
    @NotNull
    public EventType getType() {
        return this.type;
    }

    @NotNull
    public final List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public final void addCheckpoint(@NotNull Checkpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)checkpoint, (String)"checkpoint");
        this._checkpoints.add(checkpoint);
    }

    public final void removeCheckpoint(@NotNull Checkpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)checkpoint, (String)"checkpoint");
        this._checkpoints.remove(checkpoint);
    }

    @Override
    @NotNull
    public Date getEndTime() {
        return new Date(this.getStartTime().getTime() + ((Checkpoint)CollectionsKt.last(this._checkpoints)).getElapsedTime());
    }

    public GestureEvent() {
        this(null, null, 3, null);
    }
}

