/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerTimingAnalyzer {
    static final String DTSINFO_PATTERN = "(?:dtSInfo;desc=\"?)(.*?)(?:\"|;|$)";
    static final int MAX_LENGTH = 50;
    private final Pattern pattern;
    private final int maxLength;

    public ServerTimingAnalyzer() {
        this(DTSINFO_PATTERN, 50);
    }

    protected ServerTimingAnalyzer(String pattern, int maxLength) {
        this.pattern = Pattern.compile(pattern);
        this.maxLength = maxLength;
    }

    public String analyze(List<String> values) {
        if (values == null) {
            return null;
        }
        for (String value : values) {
            Matcher m = this.pattern.matcher(value);
            if (!m.find()) continue;
            String result = m.group(1);
            if (result != null && result.length() > this.maxLength) {
                return result.substring(0, this.maxLength);
            }
            return result;
        }
        return null;
    }
}

